/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.PropertiesConfigSourceProvider;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ProfilePropertiesConfigSourceProvider
implements ConfigSourceProvider {
    private final List<ConfigSource> configSources;

    public ProfilePropertiesConfigSourceProvider(final String propertyFileName, final boolean optional, final ClassLoader classLoader) {
        ConfigurableConfigSource configurableConfigSource = new ConfigurableConfigSource(new ConfigSourceFactory(){

            @Override
            public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
                ConfigValue value = context.getValue("smallrye.config.profile");
                if (value != null) {
                    String profileName = value.getValue();
                    PropertiesConfigSourceProvider propertiesConfigSourceProvider = new PropertiesConfigSourceProvider(ProfilePropertiesConfigSourceProvider.addProfileToPropertyFileName(propertyFileName, profileName), optional, classLoader);
                    return propertiesConfigSourceProvider.getConfigSources(classLoader);
                }
                return Collections.emptyList();
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(101);
            }
        });
        this.configSources = Collections.singletonList(configurableConfigSource);
    }

    public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
        return this.configSources;
    }

    private static String addProfileToPropertyFileName(String propertyFileName, String profile) {
        int dot = propertyFileName.lastIndexOf(".");
        if (dot != -1) {
            return propertyFileName.substring(0, dot) + "-" + profile + propertyFileName.substring(dot);
        }
        return propertyFileName + "-" + profile;
    }
}

