/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.AbstractDelegatingConverter;
import io.smallrye.config.inject.InjectionMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigProducerUtil {
    private ConfigProducerUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        if (ConfigProducerUtil.hasCollection(injectionPoint.getType())) {
            return ConfigProducerUtil.convertValues(name, injectionPoint.getType(), ConfigProducerUtil.getDefaultValue(injectionPoint), config);
        }
        return ConfigProducerUtil.convertValue(name, ConfigProducerUtil.resolveConverter(injectionPoint, config), ConfigProducerUtil.getDefaultValue(injectionPoint), config);
    }

    public static <T> T getValue(String name, Type type, String defaultValue, Config config) {
        if (name == null) {
            return null;
        }
        return ConfigProducerUtil.convertValue(name, ConfigProducerUtil.resolveConverter(type, config), defaultValue, config);
    }

    public static <T> T convertValue(String name, Converter<T> converter, String defaultValue, Config config) {
        Object converted;
        String rawValue = ConfigProducerUtil.getRawValue(name, config);
        if (rawValue == null) {
            rawValue = defaultValue;
        }
        if (rawValue == null) {
            try {
                converted = converter.convert("");
            }
            catch (IllegalArgumentException ignored) {
                throw InjectionMessages.msg.propertyNotFound(name);
            }
        } else {
            converted = converter.convert(rawValue);
        }
        if (converted == null) {
            throw InjectionMessages.msg.propertyNotFound(name);
        }
        return (T)converted;
    }

    public static <T> T convertValues(String name, Type type, String defaultValue, Config config) {
        String rawValue = ConfigProducerUtil.getRawValue(name, config);
        List indexedProperties = ((SmallRyeConfig)config).getIndexedProperties(name);
        if (rawValue != null || indexedProperties.isEmpty()) {
            return ConfigProducerUtil.convertValue(name, ConfigProducerUtil.resolveConverter(type, config), defaultValue, config);
        }
        BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter = (itemConverter, collectionFactory) -> {
            Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
            for (String indexedProperty : indexedProperties) {
                collection.add(ConfigProducerUtil.convertValue(indexedProperty, itemConverter, null, config));
            }
            return collection;
        };
        return (T)ConfigProducerUtil.resolveConverterForIndexed(type, config, indexedConverter).convert(" ");
    }

    public static org.eclipse.microprofile.config.ConfigValue getConfigValue(InjectionPoint injectionPoint, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        org.eclipse.microprofile.config.ConfigValue configValue = config.getConfigValue(name);
        if (configValue.getRawValue() == null && configValue instanceof ConfigValue) {
            configValue = ((ConfigValue)configValue).withValue(ConfigProducerUtil.getDefaultValue(injectionPoint));
        }
        return configValue;
    }

    public static String getRawValue(String name, Config config) {
        return (String)SecretKeys.doUnlocked(() -> config.getConfigValue(name).getValue());
    }

    public static <T> Converter<T> resolveConverter(InjectionPoint injectionPoint, Config config) {
        return ConfigProducerUtil.resolveConverter(injectionPoint.getType(), config);
    }

    private static <T> Converter<T> resolveConverter(Type type, Config config) {
        Class rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), ArrayList::new);
            }
            if (rawType == Set.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), HashSet::new);
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config));
            }
            if (rawType == Supplier.class) {
                return ConfigProducerUtil.resolveConverter(typeArgs[0], config);
            }
        }
        return (Converter)config.getConverter(rawType).orElseThrow(() -> InjectionMessages.msg.noRegisteredConverter(rawType));
    }

    private static <T> Converter<T> resolveConverterForIndexed(Type type, Config config, BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter) {
        Class<T> rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return new IndexedCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), ArrayList::new, indexedConverter);
            }
            if (rawType == Set.class) {
                return new IndexedCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), HashSet::new, indexedConverter);
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverterForIndexed(typeArgs[0], config, indexedConverter));
            }
            if (rawType == Supplier.class) {
                return ConfigProducerUtil.resolveConverterForIndexed(typeArgs[0], config, indexedConverter);
            }
        }
        throw new IllegalStateException();
    }

    private static <T> Class<T> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigProducerUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigProducerUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw InjectionMessages.msg.noRawType(type);
    }

    private static <T> boolean hasCollection(Type type) {
        Class<T> rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return true;
            }
            if (rawType == Set.class) {
                return true;
            }
            return ConfigProducerUtil.hasCollection(typeArgs[0]);
        }
        return false;
    }

    public static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    public static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            String str = ((ConfigProperty)qualifier).defaultValue();
            if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(str)) {
                return str;
            }
            Class rawType = ConfigProducerUtil.rawTypeOf(injectionPoint.getType());
            if (rawType.isPrimitive()) {
                if (rawType == Character.TYPE) {
                    return null;
                }
                if (rawType == Boolean.TYPE) {
                    return "false";
                }
                return "0";
            }
            return null;
        }
        return null;
    }

    public static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (!key.trim().isEmpty()) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            String[] parts = declaringType.getJavaClass().getCanonicalName().split("\\.");
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(".").append(parts[i]);
            }
            sb.append(".").append(member.getJavaMember().getName());
            return sb.toString();
        }
        throw InjectionMessages.msg.noConfigPropertyDefaultName(ip);
    }

    static final class IndexedCollectionConverter<T, C extends Collection<T>>
    extends AbstractDelegatingConverter<T, C> {
        private static final long serialVersionUID = 5186940408317652618L;
        private final IntFunction<Collection<T>> collectionFactory;
        private final BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter;

        public IndexedCollectionConverter(Converter<T> resolveConverter, IntFunction<Collection<T>> collectionFactory, BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter) {
            super(resolveConverter);
            this.collectionFactory = collectionFactory;
            this.indexedConverter = indexedConverter;
        }

        public C convert(String value) throws IllegalArgumentException, NullPointerException {
            return (C)this.indexedConverter.apply(this.getDelegate(), this.collectionFactory);
        }
    }
}

