/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.gizmo2;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ComparableOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;

public final class StringBuilderGen
extends ObjectOps
implements ComparableOps {
    public static StringBuilderGen ofNew(BlockCreator bc) {
        return new StringBuilderGen(bc, (Var)bc.localVar("$$stringBuilder", bc.new_(StringBuilder.class)));
    }

    public static StringBuilderGen ofNew(int capacity, BlockCreator bc) {
        return new StringBuilderGen(bc, (Var)bc.localVar("$$stringBuilder", bc.new_(StringBuilder.class, (Expr)Const.of((int)capacity))));
    }

    public static StringBuilderGen of(Var stringBuilder, BlockCreator bc) {
        return new StringBuilderGen(bc, stringBuilder);
    }

    private StringBuilderGen(BlockCreator bc, Var obj) {
        super(StringBuilder.class, bc, (Expr)obj);
    }

    public StringBuilderGen append(Expr expr) {
        switch (expr.type().descriptorString()) {
            case "Z": {
                this.invokeInstance(StringBuilder.class, "append", Boolean.TYPE, expr);
                break;
            }
            case "B": 
            case "S": 
            case "I": {
                this.invokeInstance(StringBuilder.class, "append", Integer.TYPE, expr);
                break;
            }
            case "J": {
                this.invokeInstance(StringBuilder.class, "append", Long.TYPE, expr);
                break;
            }
            case "F": {
                this.invokeInstance(StringBuilder.class, "append", Float.TYPE, expr);
                break;
            }
            case "D": {
                this.invokeInstance(StringBuilder.class, "append", Double.TYPE, expr);
                break;
            }
            case "C": {
                this.invokeInstance(StringBuilder.class, "append", Character.TYPE, expr);
                break;
            }
            case "[C": {
                this.invokeInstance(StringBuilder.class, "append", char[].class, expr);
                break;
            }
            case "Ljava/lang/String;": {
                this.invokeInstance(StringBuilder.class, "append", String.class, expr);
                break;
            }
            case "Ljava/lang/CharSequence;": {
                this.invokeInstance(StringBuilder.class, "append", CharSequence.class, expr);
                break;
            }
            default: {
                this.invokeInstance(StringBuilder.class, "append", Object.class, expr);
            }
        }
        return this;
    }

    public StringBuilderGen append(char constant) {
        return this.append((Expr)Const.of((char)constant));
    }

    public StringBuilderGen append(String constant) {
        return this.append((Expr)Const.of((String)constant));
    }

    public StringBuilderGen appendCodePoint(Expr codePoint) {
        this.invokeInstance(StringBuilder.class, "appendCodePoint", Integer.TYPE, codePoint);
        return this;
    }

    public StringBuilderGen appendCodePoint(int codePoint) {
        return this.appendCodePoint((Expr)Const.of((int)codePoint));
    }

    public void setLength(Expr length) {
        this.invokeInstance(Void.TYPE, "setLength", Integer.TYPE, length);
    }

    public void setLength(int length) {
        this.setLength((Expr)Const.of((int)length));
    }

    public Expr compareTo(Expr other) {
        return this.invokeInstance(Integer.TYPE, "compareTo", StringBuilder.class, other);
    }
}

