/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.jboss.jandex.ClassSummary;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.maven.ArchiveScanner;
import org.jboss.jandex.maven.Dependency;
import org.jboss.jandex.maven.FileSet;

@Mojo(name="jandex", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JandexGoal
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classesDir;
    @Parameter
    private List<FileSet> fileSets;
    @Parameter(defaultValue="true")
    private boolean processDefaultFileSet;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF")
    private File indexDir;
    @Parameter(defaultValue="jandex.idx")
    private String indexName;
    @Parameter(property="jandex.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Jandex execution skipped");
            return;
        }
        if (this.fileSets == null) {
            this.fileSets = new ArrayList<FileSet>();
        }
        if (this.processDefaultFileSet) {
            boolean explicitlyConfigured = false;
            for (FileSet fileset : this.fileSets) {
                if (fileset.getDirectory() == null || !fileset.getDirectory().equals(this.classesDir)) continue;
                explicitlyConfigured = true;
                break;
            }
            if (!explicitlyConfigured) {
                FileSet fs = new FileSet();
                fs.setDirectory(this.classesDir);
                fs.setIncludes(Collections.singletonList("**/*.class"));
                this.fileSets.add(fs);
            }
        }
        Indexer indexer = new Indexer();
        for (FileSet fileSet : this.fileSets) {
            if (fileSet.getDirectory() == null && fileSet.getDependency() == null) {
                throw new MojoExecutionException("File set must specify either directory or dependency");
            }
            if (fileSet.getDirectory() != null && fileSet.getDependency() != null) {
                throw new MojoExecutionException("File set may not specify both directory and dependency");
            }
            if (fileSet.getDirectory() != null) {
                this.indexDirectory(indexer, fileSet);
                continue;
            }
            if (fileSet.getDependency() == null) continue;
            this.indexDependency(indexer, fileSet);
        }
        Index index = indexer.complete();
        File indexFile = new File(this.indexDir, this.indexName);
        this.getLog().info((CharSequence)("Saving Jandex index: " + indexFile));
        try {
            Files.createDirectories(this.indexDir.toPath(), new FileAttribute[0]);
            try (CachingOutputStream out = new CachingOutputStream(indexFile);){
                IndexWriter writer = new IndexWriter((OutputStream)out);
                writer.write(index);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not save index " + indexFile, (Exception)e);
        }
    }

    private void indexDirectory(Indexer indexer, FileSet fileSet) throws MojoExecutionException {
        String[] files;
        File dir = fileSet.getDirectory();
        if (!dir.exists()) {
            this.getLog().warn((CharSequence)("Skipping file set, directory does not exist: " + fileSet.getDirectory()));
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        for (String file : files = this.findFilesToIndex(fileSet, (Scanner)scanner)) {
            if (!file.endsWith(".class")) continue;
            try (InputStream in = Files.newInputStream(new File(dir, file).toPath(), new OpenOption[0]);){
                ClassSummary info = indexer.indexWithSummary(in);
                if (!this.isVerbose() || info == null) continue;
                this.getLog().info((CharSequence)("Indexed " + info.name() + " (" + info.annotationsCount() + " annotations)"));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private void indexDependency(Indexer indexer, FileSet fileSet) throws MojoExecutionException {
        Dependency dependency = fileSet.getDependency();
        if (dependency.getGroupId() == null) {
            throw new MojoExecutionException("Dependency in file set must specify groupId");
        }
        if (dependency.getArtifactId() == null) {
            throw new MojoExecutionException("Dependency in file set must specify artifactId");
        }
        Artifact artifact = null;
        for (Artifact candidate : this.mavenProject.getArtifacts()) {
            if (!candidate.getGroupId().equals(dependency.getGroupId()) || !candidate.getArtifactId().equals(dependency.getArtifactId()) || dependency.getClassifier() != null && !candidate.getClassifier().equals(dependency.getClassifier())) continue;
            artifact = candidate;
            break;
        }
        if (artifact == null) {
            this.getLog().warn((CharSequence)("Skipping file set, artifact not found among this project dependencies: " + dependency));
            return;
        }
        File archive = artifact.getFile();
        if (archive == null) {
            this.getLog().warn((CharSequence)("Skipping file set, artifact file does not exist for dependency: " + dependency));
            return;
        }
        ArchiveScanner scanner = new ArchiveScanner(archive);
        String[] files = this.findFilesToIndex(fileSet, (Scanner)scanner);
        try (ZipFile zip = new ZipFile(archive);){
            for (String file : files) {
                if (!file.endsWith(".class")) continue;
                try (InputStream in = zip.getInputStream(zip.getEntry(file));){
                    ClassSummary info = indexer.indexWithSummary(in);
                    if (!this.isVerbose() || info == null) continue;
                    this.getLog().info((CharSequence)("Indexed " + info.name() + " (" + info.annotationsCount() + " annotations)"));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String[] findFilesToIndex(FileSet fileSet, Scanner scanner) {
        List<String> excludes;
        List<String> includes;
        scanner.setFilenameComparator(String::compareTo);
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        if ((includes = fileSet.getIncludes()) != null) {
            scanner.setIncludes(includes.toArray(new String[0]));
        }
        if ((excludes = fileSet.getExcludes()) != null) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private boolean isVerbose() {
        return this.verbose || this.getLog().isDebugEnabled();
    }
}

