/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.util.AbstractScanner;

final class ArchiveScanner
extends AbstractScanner {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final File archive;
    private ArrayList<String> filesIncluded;

    ArchiveScanner(File archive) {
        this.archive = archive;
    }

    public void scan() {
        if (this.archive == null) {
            throw new IllegalStateException("No archive set");
        }
        if (!this.archive.exists()) {
            throw new IllegalStateException("Archive " + this.archive + " does not exist");
        }
        if (!this.archive.isFile()) {
            throw new IllegalStateException("Archive " + this.archive + " is not a file");
        }
        this.setupDefaultFilters();
        this.setupMatchPatterns();
        this.filesIncluded = new ArrayList();
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile zip = new ZipFile(this.archive);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                files.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.filenameComparator != null) {
            files.sort(this.filenameComparator);
        }
        for (String file : files) {
            String forMatching = file.replace('/', File.separatorChar);
            if (!this.isIncluded(forMatching) || this.isExcluded(forMatching)) continue;
            this.filesIncluded.add(file);
        }
    }

    public String[] getIncludedFiles() {
        return this.filesIncluded.toArray(EMPTY_STRING_ARRAY);
    }

    public String[] getIncludedDirectories() {
        throw new UnsupportedOperationException();
    }

    public File getBasedir() {
        return this.archive;
    }
}

