/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.llm.core.langchain4j.portableextension;

import io.smallrye.llm.aiservice.CommonAIServiceCreator;
import io.smallrye.llm.spi.RegisterAIService;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LangChain4JAIServiceBean<T>
implements Bean<T>,
PassivationCapable {
    private final Class<T> aiServiceInterfaceClass;
    private final BeanManager beanManager;
    private final Class<? extends Annotation> scope;
    private Set<Annotation> interceptorBindings;

    public LangChain4JAIServiceBean(Class<T> aiServiceInterfaceClass, BeanManager beanManager) {
        this.aiServiceInterfaceClass = aiServiceInterfaceClass;
        RegisterAIService annotation = this.aiServiceInterfaceClass.getAnnotation(RegisterAIService.class);
        this.scope = annotation.scope();
        this.beanManager = beanManager;
    }

    public String getId() {
        return this.aiServiceInterfaceClass.getName();
    }

    public T create(CreationalContext<T> creationalContext) {
        Object instance = CommonAIServiceCreator.create((Instance)CDI.current(), this.aiServiceInterfaceClass);
        if (!this.getInterceptorBindings().isEmpty()) {
            InterceptionFactory factory = this.beanManager.createInterceptionFactory(creationalContext, this.aiServiceInterfaceClass);
            this.interceptorBindings.stream().forEach(arg_0 -> ((AnnotatedTypeConfigurator)factory.configure()).add(arg_0));
            instance = factory.createInterceptedInstance(instance);
        }
        return (T)instance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.aiServiceInterfaceClass);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<AnnotationLiteral> annotations = new HashSet<AnnotationLiteral>();
        annotations.add(new AnnotationLiteral<Default>(){});
        annotations.add(new AnnotationLiteral<Any>(){});
        return Collections.unmodifiableSet(annotations);
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return "registeredAIService-" + this.aiServiceInterfaceClass.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.singleton(RegisterAIService.class);
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return this.aiServiceInterfaceClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Annotation> getInterceptorBindings() {
        if (this.interceptorBindings == null) {
            this.interceptorBindings = new HashSet<Annotation>();
        }
        return this.interceptorBindings;
    }

    public String toString() {
        return "AiService [ interfaceType: " + this.aiServiceInterfaceClass.getSimpleName() + " ] with Qualifiers [" + String.valueOf(this.getQualifiers()) + "]";
    }
}

