/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.llm.core.langchain4j.portableextension;

import io.smallrye.llm.core.langchain4j.portableextension.LangChain4JAIServiceBean;
import io.smallrye.llm.core.langchain4j.portableextension.Reflections;
import io.smallrye.llm.spi.RegisterAIService;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

public class LangChain4JAIServicePortableExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(LangChain4JAIServicePortableExtension.class);
    private static final Set<Class<?>> detectedAIServicesDeclaredInterfaces = new HashSet();

    public static Set<Class<?>> getDetectedAIServicesDeclaredInterfaces() {
        return detectedAIServicesDeclaredInterfaces;
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={RegisterAIService.class}) ProcessAnnotatedType<T> pat) {
        if (pat.getAnnotatedType().getJavaClass().isInterface()) {
            LOGGER.info((Object)("processAnnotatedType register " + pat.getAnnotatedType().getJavaClass().getName()));
            detectedAIServicesDeclaredInterfaces.add(pat.getAnnotatedType().getJavaClass());
        } else {
            LOGGER.warn((Object)("processAnnotatedType reject " + pat.getAnnotatedType().getJavaClass().getName() + " which is not an interface"));
            pat.veto();
        }
    }

    void processInjectionPoints(@Observes ProcessInjectionPoint<?, ?> event) {
        Class parameterizedType;
        Class rawType;
        if (event.getInjectionPoint().getBean() == null && this.classSatisfies(rawType = Reflections.getRawType(event.getInjectionPoint().getType()), RegisterAIService.class)) {
            detectedAIServicesDeclaredInterfaces.add(rawType);
        }
        if (Instance.class.equals(Reflections.getRawType(event.getInjectionPoint().getType())) && this.classSatisfies(parameterizedType = Reflections.getRawType(this.getFacadeType(event.getInjectionPoint())), RegisterAIService.class)) {
            detectedAIServicesDeclaredInterfaces.add(parameterizedType);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) throws ClassNotFoundException {
        for (Class<?> aiServiceClass : detectedAIServicesDeclaredInterfaces) {
            LOGGER.info((Object)("afterBeanDiscovery create synthetic:  " + aiServiceClass.getName()));
            afterBeanDiscovery.addBean(new LangChain4JAIServiceBean(aiServiceClass, beanManager));
        }
    }

    private <T extends Annotation> boolean classSatisfies(Class<?> clazz, Class<T> annotationClass) {
        if (!clazz.isInterface()) {
            return false;
        }
        T annotation = clazz.getAnnotation(annotationClass);
        return annotation != null;
    }

    private Type getFacadeType(InjectionPoint injectionPoint) {
        Type genericType = injectionPoint.getType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return null;
    }
}

