/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.llm.core.langchain4j.portableextension;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class Reflections {
    private Reflections() {
        throw new AssertionError((Object)"Private Constructor.");
    }

    public static <T> Class<T> getRawType(Type type) {
        GenericArrayType genericArrayType;
        Class<T> rawType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            Type[] bounds = variable.getBounds();
            return Reflections.getBound(bounds);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            return Reflections.getBound(wildcard.getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = Reflections.getRawType((genericArrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        return null;
    }

    private static <T> Class<T> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return Reflections.getRawType(bounds[0]);
    }
}

