/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class OtlpExporterUtil {
    private OtlpExporterUtil() {
    }

    public static int getPort(URI uri) {
        int originalPort = uri.getPort();
        if (originalPort > -1) {
            return originalPort;
        }
        if (OtlpExporterUtil.isHttps(uri)) {
            return 443;
        }
        return 80;
    }

    public static Map<String, String> populateTracingExportHttpHeaders() {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("User-Agent", "io.smallrye.opentelemetry " + OpenTelemetryConfig.INSTRUMENTATION_VERSION);
        return headersMap;
    }

    public static boolean isHttps(URI uri) {
        return "https".equals(uri.getScheme().toLowerCase(Locale.ROOT));
    }

    public static String getConfig(ConfigProperties config, String defaultValue, String ... keys) {
        return Arrays.stream(keys).map(arg_0 -> ((ConfigProperties)config).getString(arg_0)).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }

    public static String getProtocol(ConfigProperties config, String signalType) {
        String signalKey = signalType.replace("span", "traces");
        return OtlpExporterUtil.getConfig(config, "grpc", String.format("otel.exporter.otlp.%s.protocol", signalKey), "otel.exporter.otlp.protocol");
    }

    public static boolean getCompression(ConfigProperties config, String signalType) {
        return Boolean.parseBoolean(OtlpExporterUtil.getConfig(config, "true", String.format("otel.exporter.otlp.%s.compression", signalType), "otel.exporter.otlp.compression"));
    }

    public static Duration getTimeout(ConfigProperties config, String signalType) {
        return Duration.ofSeconds(Integer.parseInt(OtlpExporterUtil.getConfig(config, "10", String.format("otel.exporter.otlp.%s.timeout", signalType), "otel.exporter.otlp.timeout")));
    }

    public static String getOtlpEndpoint(ConfigProperties config, String defaultEndpoint, String signalType) {
        return OtlpExporterUtil.getConfig(config, defaultEndpoint, String.format("otel.exporter.otlp.%s.endpoint", signalType), "otel.exporter.otlp.endpoint");
    }
}

