/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters.traces;

import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.smallrye.opentelemetry.implementation.exporters.AbstractVertxExporterProvider;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.smallrye.opentelemetry.implementation.exporters.traces.VertxGrpcSpanExporter;
import io.smallrye.opentelemetry.implementation.exporters.traces.VertxHttpSpanExporter;
import java.net.URISyntaxException;

public class VertxSpanExporterProvider
extends AbstractVertxExporterProvider<TraceRequestMarshaler>
implements ConfigurableSpanExporterProvider {
    public VertxSpanExporterProvider() {
        super("span", "otlp");
    }

    public SpanExporter createExporter(ConfigProperties config) {
        try {
            String protocol = OtlpExporterUtil.getProtocol(config, this.getSignalType());
            if ("grpc".equals(protocol)) {
                return new VertxGrpcSpanExporter(this.createGrpcExporter(config, "opentelemetry.proto.collector.trace.v1.TraceService"));
            }
            if ("http/protobuf".equals(protocol)) {
                return new VertxHttpSpanExporter(this.createHttpExporter(config, "/v1/traces"));
            }
            throw this.buildUnsupportedProtocolException(protocol);
        }
        catch (IllegalArgumentException | URISyntaxException iae) {
            throw new IllegalStateException("Unable to install OTLP Exporter", iae);
        }
    }
}

