/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.MultiInterceptor;
import io.smallrye.mutiny.operators.AbstractMulti;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContextPropagationMultiInterceptor
implements MultiInterceptor {
    static final ThreadContext THREAD_CONTEXT = ContextManagerProvider.instance().getContextManager().newThreadContextBuilder().build();

    public <T> Subscriber<? super T> onSubscription(Publisher<? extends T> instance, final Subscriber<? super T> subscriber) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new Subscriber<T>(){

            public void onSubscribe(Subscription subscription) {
                executor.execute(() -> subscriber.onSubscribe(subscription));
            }

            public void onNext(T item) {
                executor.execute(() -> subscriber.onNext(item));
            }

            public void onError(Throwable failure) {
                executor.execute(() -> subscriber.onError(failure));
            }

            public void onComplete() {
                executor.execute(() -> ((Subscriber)subscriber).onComplete());
            }
        };
    }

    public <T> Multi<T> onMultiCreation(final Multi<T> multi) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new AbstractMulti<T>(){

            public void subscribe(Subscriber<? super T> subscriber) {
                executor.execute(() -> multi.subscribe().withSubscriber(subscriber));
            }
        };
    }
}

