/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.vertxpublishers;

import io.vertx.core.Future;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import mutiny.zero.vertxpublishers.NoopSubscription;
import mutiny.zero.vertxpublishers.PublisherBase;

class SuppliedFutureStreamPublisher<T>
extends PublisherBase<T> {
    private final Supplier<Future<? extends ReadStream<T>>> futureStreamSupplier;

    SuppliedFutureStreamPublisher(Supplier<Future<? extends ReadStream<T>>> futureStreamSupplier) {
        this.futureStreamSupplier = futureStreamSupplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Future<? extends ReadStream<T>> future;
        try {
            future = this.futureStreamSupplier.get();
        }
        catch (Throwable err2) {
            subscriber.onSubscribe(new NoopSubscription());
            subscriber.onError(err2);
            return;
        }
        if (future == null) {
            subscriber.onSubscribe(new NoopSubscription());
            subscriber.onError(new NullPointerException("The future cannot be null"));
        } else {
            future.onSuccess(stream -> this.adapt(subscriber, stream));
            future.onFailure(err -> {
                subscriber.onSubscribe(new NoopSubscription());
                subscriber.onError((Throwable)err);
            });
        }
    }
}

