/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.vertxpublishers;

import io.vertx.core.streams.ReadStream;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import mutiny.zero.vertxpublishers.NoopSubscription;
import mutiny.zero.vertxpublishers.PublisherBase;

class SuppliedStreamPublisher<T>
extends PublisherBase<T> {
    private final Supplier<ReadStream<T>> streamSupplier;

    SuppliedStreamPublisher(Supplier<ReadStream<T>> streamSupplier) {
        this.streamSupplier = streamSupplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        ReadStream<T> stream;
        try {
            stream = this.streamSupplier.get();
        }
        catch (Throwable err) {
            subscriber.onSubscribe(new NoopSubscription());
            subscriber.onError(err);
            return;
        }
        if (stream == null) {
            subscriber.onSubscribe(new NoopSubscription());
            subscriber.onError(new NullPointerException("The stream cannot be null"));
        } else {
            this.adapt(subscriber, stream);
        }
    }
}

