/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.vertxpublishers;

import io.vertx.core.Future;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import mutiny.zero.vertxpublishers.SuppliedFutureStreamPublisher;
import mutiny.zero.vertxpublishers.SuppliedStreamPublisher;

public interface VertxPublisher {
    public static <T> Flow.Publisher<T> fromSupplier(Supplier<ReadStream<T>> streamSupplier) {
        Objects.requireNonNull(streamSupplier, "The stream supplier cannot be null");
        return new SuppliedStreamPublisher<T>(streamSupplier);
    }

    public static <T> Flow.Publisher<T> fromFuture(Supplier<Future<? extends ReadStream<T>>> futureStreamSupplier) {
        Objects.requireNonNull(futureStreamSupplier, "The future supplier cannot be null");
        return new SuppliedFutureStreamPublisher(futureStreamSupplier);
    }
}

