/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiCollectorOp;
import io.smallrye.mutiny.operators.multi.MultiLastItemOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class MultiCollect<T> {
    private final Multi<T> upstream;

    public MultiCollect(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> first() {
        return Uni.createFrom().multi(this.upstream);
    }

    public Uni<T> last() {
        return Uni.createFrom().publisher(Infrastructure.onMultiCreation(new MultiLastItemOp<T>(this.upstream)));
    }

    public Uni<List<T>> asList() {
        return MultiCollect.collector(this.upstream, Collectors.toList(), false);
    }

    public <X, A> Uni<X> with(Collector<? super T, A, ? extends X> collector) {
        return MultiCollect.collector(this.upstream, collector, true);
    }

    public <X> Uni<X> in(Supplier<X> supplier, BiConsumer<X, T> accumulator) {
        Collector<T, X, X> collector = Collector.of(supplier, accumulator, (r, r2) -> r, Collector.Characteristics.IDENTITY_FINISH);
        return MultiCollect.collector(this.upstream, collector, false);
    }

    public <K> Uni<Map<K, T>> asMap(Function<? super T, ? extends K> keyMapper) {
        return this.asMap(keyMapper, Function.identity());
    }

    public <K, V> Uni<Map<K, V>> asMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollect.collector(this.upstream, Collectors.toMap(keyMapper, valueMapper), false);
    }

    public <K, V> Uni<Map<K, Collection<V>>> asMultiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollect.collector(this.upstream, Collectors.toMap(keyMapper, res -> {
            ArrayList list = new ArrayList();
            Object mapped = valueMapper.apply(res);
            list.add(mapped);
            return list;
        }, (vs, vs2) -> {
            vs.addAll(vs2);
            return vs;
        }), false);
    }

    public <K> Uni<Map<K, Collection<T>>> asMultiMap(Function<? super T, ? extends K> keyMapper) {
        return this.asMultiMap(keyMapper, Function.identity());
    }

    public MultiCollect<T> where(Predicate<T> predicate) {
        return new MultiCollect<T>(this.upstream.select().where(predicate));
    }

    public MultiCollect<T> when(Function<? super T, Uni<Boolean>> predicate) {
        return new MultiCollect<T>(this.upstream.select().when(predicate));
    }

    private static <T, A, R> Uni<R> collector(Multi<T> upstream, Collector<? super T, A, ? extends R> collector, boolean acceptNullAsInitialValue) {
        Multi multi = Infrastructure.onMultiCreation(new MultiCollectorOp<T, A, R>(upstream, collector, acceptNullAsInitialValue));
        return Uni.createFrom().publisher(multi);
    }
}

