/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class UniDelayUntil<T>
extends UniOperator<T, T> {
    private final Function<? super T, Uni<?>> function;
    private final ScheduledExecutorService executor;

    public UniDelayUntil(Uni<T> upstream, Function<? super T, Uni<?>> function, ScheduledExecutorService executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.function = ParameterValidation.nonNull(function, "function");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        final AtomicReference reference = new AtomicReference();
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                if (reference.compareAndSet(null, subscription)) {
                    super.onSubscribe(() -> {
                        if (reference.compareAndSet(subscription, EmptyUniSubscription.CANCELLED)) {
                            subscription.cancel();
                        }
                    });
                }
            }

            @Override
            public void onItem(T item) {
                if (reference.get() != EmptyUniSubscription.CANCELLED) {
                    try {
                        Uni uni = (Uni)UniDelayUntil.this.function.apply(item);
                        if (uni == null) {
                            super.onFailure(new NullPointerException("The function returned `null` instead of a valid `Uni`"));
                            return;
                        }
                        uni.runSubscriptionOn(UniDelayUntil.this.executor).subscribe().with(x -> {
                            if (reference.get() != EmptyUniSubscription.CANCELLED) {
                                super.onItem(item);
                            }
                        }, x$0 -> super.onFailure((Throwable)x$0));
                    }
                    catch (RuntimeException e) {
                        super.onFailure(e);
                    }
                }
            }
        });
    }
}

