/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.builders.DefaultUniEmitter;
import io.smallrye.mutiny.operators.uni.builders.StateHolder;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class UniCreateFromEmitterWithState<T, S>
extends AbstractUni<T> {
    private final BiConsumer<S, UniEmitter<? super T>> consumer;
    private final StateHolder<S> holder;

    public UniCreateFromEmitterWithState(Supplier<S> stateSupplier, BiConsumer<S, UniEmitter<? super T>> consumer) {
        this.consumer = consumer;
        this.holder = new StateHolder<S>(stateSupplier);
    }

    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        S state;
        try {
            state = this.holder.get();
        }
        catch (Exception e) {
            subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
            subscriber.onFailure(e);
            return;
        }
        DefaultUniEmitter<T> emitter = new DefaultUniEmitter<T>(subscriber);
        subscriber.onSubscribe(emitter);
        try {
            this.consumer.accept(state, emitter);
        }
        catch (RuntimeException e) {
            emitter.fail(e);
        }
    }
}

