/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class UniOnCancellationCall<I>
extends UniOperator<I, I> {
    private final Supplier<Uni<?>> supplier;

    public UniOnCancellationCall(Uni<? extends I> upstream, Supplier<Uni<?>> supplier) {
        super(upstream);
        this.supplier = supplier;
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnCancellationCallProcessor(subscriber));
    }

    private class UniOnCancellationCallProcessor
    extends UniOperatorProcessor<I, I> {
        private final AtomicReference<State> state;

        public UniOnCancellationCallProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
            this.state = new AtomicReference<State>(State.INIT);
        }

        @Override
        public void onItem(I item) {
            if (this.state.compareAndSet(State.INIT, State.DONE)) {
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.state.compareAndSet(State.INIT, State.DONE)) {
                this.downstream.onFailure(failure);
            }
        }

        @Override
        public void cancel() {
            if (this.state.compareAndSet(State.INIT, State.CANCELLED)) {
                UniSubscription sub = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
                this.execute().subscribe().with(ignoredItem -> {
                    if (sub != null) {
                        sub.cancel();
                    }
                }, ignoredException -> {
                    Infrastructure.handleDroppedException(ignoredException);
                    if (sub != null) {
                        sub.cancel();
                    }
                });
            }
        }

        private Uni<?> execute() {
            try {
                return ParameterValidation.nonNull((Uni)UniOnCancellationCall.this.supplier.get(), "uni");
            }
            catch (Throwable err) {
                return Uni.createFrom().failure(err);
            }
        }
    }

    private static enum State {
        INIT,
        DONE,
        CANCELLED;

    }
}

