/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class UniCreateFromCompletionStage<O>
extends UniOperator<Void, O> {
    private final Supplier<? extends CompletionStage<? extends O>> supplier;

    public UniCreateFromCompletionStage(Supplier<? extends CompletionStage<? extends O>> supplier) {
        super(null);
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    private static <O> void forwardFromCompletionStage(CompletionStage<? extends O> stage, UniSerializedSubscriber<? super O> subscriber) {
        subscriber.onSubscribe(() -> stage.toCompletableFuture().cancel(false));
        stage.whenComplete((res, fail) -> {
            if (fail != null) {
                subscriber.onFailure((Throwable)fail);
            } else {
                subscriber.onItem(res);
            }
        });
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super O> subscriber) {
        CompletionStage<? extends O> stage;
        try {
            stage = this.supplier.get();
        }
        catch (Exception e) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, e);
            return;
        }
        if (stage == null) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, new NullPointerException("The produced completion stage is `null`"));
            return;
        }
        UniCreateFromCompletionStage.forwardFromCompletionStage(stage, subscriber);
    }
}

