/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Supplier;

public class FailedMulti<T>
extends AbstractMulti<T> {
    private final Supplier<Throwable> supplier;

    public FailedMulti(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        this.supplier = () -> failure;
    }

    public FailedMulti(Supplier<Throwable> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        this.supplier = supplier;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        try {
            Throwable throwable = this.supplier.get();
            if (throwable == null) {
                Subscriptions.fail(actual, new NullPointerException("The supplier returned `null`"));
            } else {
                Subscriptions.fail(actual, throwable);
            }
        }
        catch (Exception e) {
            Subscriptions.fail(actual, e);
        }
    }
}

