/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.concurrent.Executor;

public class UniEmitOn<I>
extends UniOperator<I, I> {
    private final Executor executor;

    UniEmitOn(Uni<I> upstream, Executor executor) {
        super(upstream);
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super I> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, I>(subscriber){

            @Override
            public void onItem(I item) {
                UniEmitOn.this.executor.execute(() -> subscriber.onItem(item));
            }

            @Override
            public void onFailure(Throwable failure) {
                UniEmitOn.this.executor.execute(() -> subscriber.onFailure(failure));
            }
        });
    }
}

