/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class UniOnNotNull<T> {
    private final Uni<T> upstream;

    public UniOnNotNull(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super T> callback) {
        return this.upstream.onItem().invoke(item -> {
            if (item != null) {
                callback.accept(item);
            }
        });
    }

    public Uni<T> invokeUni(Function<? super T, ? extends Uni<?>> action) {
        return this.upstream.onItem().invokeUni(item -> {
            if (item != null) {
                return (Uni)action.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public <R> Uni<R> apply(Function<? super T, ? extends R> mapper) {
        return this.upstream.onItem().apply(item -> {
            if (item != null) {
                return mapper.apply(item);
            }
            return null;
        });
    }

    public <R> Uni<R> produceUni(Function<? super T, ? extends Uni<? extends R>> mapper) {
        return this.upstream.onItem().produceUni((? super T item) -> {
            if (item != null) {
                return (Uni)mapper.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public <R> Multi<R> produceMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.upstream.onItem().produceMulti(item -> {
            if (item != null) {
                return (Publisher)mapper.apply(item);
            }
            return Multi.createFrom().empty();
        });
    }

    public <R> Uni<R> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends R>> mapper) {
        return this.upstream.onItem().produceCompletionStage(item -> {
            if (item != null) {
                return (CompletionStage)mapper.apply(item);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public <R> Uni<R> produceUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        return this.upstream.onItem().produceUni((? super T item, UniEmitter<? super R> emitter) -> {
            if (item != null) {
                consumer.accept((Object)item, (UniEmitter)emitter);
            } else {
                emitter.complete(null);
            }
        });
    }
}

