/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscription;

public final class MultiSignalConsumerOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<? super T> onItem;
    private final Consumer<? super Throwable> onFailure;
    private final Runnable onCompletion;
    private final BiConsumer<Throwable, Boolean> onTermination;
    private final Runnable onCancellation;
    private final LongConsumer onRequest;

    public MultiSignalConsumerOp(Multi<? extends T> upstream, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, BiConsumer<Throwable, Boolean> onTermination, LongConsumer onRequest, Runnable onCancellation) {
        super(upstream);
        this.onItem = onItem;
        this.onFailure = onFailure;
        this.onCompletion = onCompletion;
        this.onRequest = onRequest;
        this.onTermination = onTermination;
        this.onCancellation = onCancellation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber must not be `null`");
        }
        this.upstream.subscribe().withSubscriber(new SignalSubscriber(actual));
    }

    private final class SignalSubscriber
    extends MultiOperatorProcessor<T, T>
    implements MultiSubscriber<T>,
    Subscription {
        private final AtomicBoolean terminationCalled;

        SignalSubscriber(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.terminationCalled = new AtomicBoolean();
        }

        @Override
        void failAndCancel(Throwable throwable) {
            Subscription current = (Subscription)this.upstream.get();
            if (current != null) {
                current.cancel();
            }
            this.onFailure(throwable);
        }

        @Override
        public void request(long n) {
            if (MultiSignalConsumerOp.this.onRequest != null) {
                try {
                    MultiSignalConsumerOp.this.onRequest.accept(n);
                }
                catch (Throwable e) {
                    this.failAndCancel(e);
                    return;
                }
            }
            ((Subscription)this.upstream.get()).request(n);
        }

        @Override
        public void cancel() {
            if (MultiSignalConsumerOp.this.onCancellation != null) {
                try {
                    MultiSignalConsumerOp.this.onCancellation.run();
                }
                catch (Throwable e) {
                    this.failAndCancel(e);
                    return;
                }
            }
            this.callTerminationCallback(null, true);
            ((Subscription)this.upstream.getAndSet(Subscriptions.CANCELLED)).cancel();
        }

        private boolean callTerminationCallback(Throwable failure, boolean cancelled) {
            block4: {
                if (this.terminationCalled.compareAndSet(false, true) && MultiSignalConsumerOp.this.onTermination != null) {
                    try {
                        MultiSignalConsumerOp.this.onTermination.accept(failure, cancelled);
                    }
                    catch (Throwable e) {
                        if (failure == null && !cancelled) {
                            this.downstream.onFailure(e);
                            return true;
                        }
                        if (failure == null) break block4;
                        this.downstream.onFailure(new CompositeException(failure, e));
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void onItem(T t) {
            if (this.upstream.get() != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onItem != null) {
                    try {
                        MultiSignalConsumerOp.this.onItem.accept(t);
                    }
                    catch (Throwable e) {
                        this.failAndCancel(e);
                        return;
                    }
                }
                this.downstream.onItem(t);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            Subscription up = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (up != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onFailure != null) {
                    try {
                        MultiSignalConsumerOp.this.onFailure.accept(failure);
                    }
                    catch (Throwable e) {
                        failure = new CompositeException(failure, e);
                    }
                }
                if (!this.callTerminationCallback(failure, false)) {
                    this.downstream.onFailure(failure);
                }
            }
        }

        @Override
        public void onCompletion() {
            if (this.upstream.getAndSet(Subscriptions.CANCELLED) != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onCompletion != null) {
                    try {
                        MultiSignalConsumerOp.this.onCompletion.run();
                    }
                    catch (Throwable e) {
                        this.downstream.onFailure(e);
                        return;
                    }
                }
                if (!this.callTerminationCallback(null, false)) {
                    this.downstream.onCompletion();
                }
            }
        }
    }
}

