/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.helpers.ParameterValidation;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public interface DemandPacer {
    public Request initial();

    public Request apply(Request var1, long var2);

    public static class Request {
        private final long demand;
        private final Duration delay;

        public Request(long demand, Duration delay) {
            this.demand = ParameterValidation.positive(demand, "demand");
            this.delay = ParameterValidation.validate(delay, "delay");
            if (delay == ChronoUnit.FOREVER.getDuration()) {
                throw new IllegalArgumentException("ChronoUnit.FOREVER is not a correct delay value");
            }
        }

        public long demand() {
            return this.demand;
        }

        public Duration delay() {
            return this.delay;
        }

        public String toString() {
            return "Request{demand=" + this.demand + ", delay=" + this.delay + "}";
        }
    }
}

