/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.amqp;

import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.amqp.AmqpConnection;
import io.vertx.axle.amqp.AmqpMessage;
import io.vertx.axle.amqp.AmqpReceiver;
import io.vertx.axle.amqp.AmqpSender;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.concurrent.CompletionStage;

@Gen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    AmqpClient() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.axle.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    private AmqpClient __connect(final Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
                if (ar.succeeded()) {
                    connectionHandler.handle((Object)Future.succeededFuture((Object)AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
                } else {
                    connectionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpConnection> connect() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__connect((Handler<AsyncResult<AmqpConnection>>)handler));
    }

    private void __close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
    }

    public CompletionStage<Void> close() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    private AmqpClient __createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createReceiver(String address) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpClient __createReceiver(String address, final Handler<AmqpMessage> messageHandler, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<io.vertx.amqp.AmqpMessage>(){

            public void handle(io.vertx.amqp.AmqpMessage event) {
                messageHandler.handle((Object)AmqpMessage.newInstance(event));
            }
        }, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createReceiver(String address, Handler<AmqpMessage> messageHandler) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, messageHandler, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpClient __createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AmqpMessage> messageHandler, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<io.vertx.amqp.AmqpMessage>(){

            public void handle(io.vertx.amqp.AmqpMessage event) {
                messageHandler.handle((Object)AmqpMessage.newInstance(event));
            }
        }, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions, Handler<AmqpMessage> messageHandler) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, receiverOptions, messageHandler, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpClient __createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpSender> createSender(String address) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createSender(address, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    private AmqpClient __createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createSender(address, options, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

