/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.amqp;

import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.amqp.AmqpMessage;
import io.vertx.axle.amqp.AmqpReceiver;
import io.vertx.axle.amqp.AmqpSender;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

@Gen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    AmqpConnection() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    private AmqpConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private AmqpConnection __close(Handler<AsyncResult<Void>> done) {
        this.delegate.close(done);
        return this;
    }

    public CompletionStage<Void> close() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    private AmqpConnection __createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createReceiver(String address) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    @Deprecated
    private AmqpConnection __createReceiver(String address, final Handler<AmqpMessage> messageHandler, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<io.vertx.amqp.AmqpMessage>(){

            public void handle(io.vertx.amqp.AmqpMessage event) {
                messageHandler.handle((Object)AmqpMessage.newInstance(event));
            }
        }, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public CompletionStage<AmqpReceiver> createReceiver(String address, Handler<AmqpMessage> messageHandler) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, messageHandler, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    @Deprecated
    private AmqpConnection __createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AmqpMessage> messageHandler, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<io.vertx.amqp.AmqpMessage>(){

            public void handle(io.vertx.amqp.AmqpMessage event) {
                messageHandler.handle((Object)AmqpMessage.newInstance(event));
            }
        }, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public CompletionStage<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions, Handler<AmqpMessage> messageHandler) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, receiverOptions, messageHandler, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpConnection __createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpConnection __createDynamicReceiver(final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createDynamicReceiver((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpReceiver> createDynamicReceiver() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createDynamicReceiver((Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    private AmqpConnection __createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpSender> createSender(String address) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createSender(address, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    private AmqpConnection __createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createSender(address, options, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    private AmqpConnection __createAnonymousSender(final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createAnonymousSender((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<AmqpSender> createAnonymousSender() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__createAnonymousSender((Handler<AsyncResult<AmqpSender>>)handler));
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

