/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.sqlclient;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.sqlclient.PreparedQuery;
import io.vertx.axle.sqlclient.Row;
import io.vertx.axle.sqlclient.RowSet;
import io.vertx.axle.sqlclient.SqlClient;
import io.vertx.axle.sqlclient.Tuple;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Gen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    Transaction() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    private Transaction __prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<PreparedQuery> prepare(String sql) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__prepare(sql, (Handler<AsyncResult<PreparedQuery>>)handler));
    }

    private void __commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public CompletionStage<Void> commit() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__commit((Handler<AsyncResult<Void>>)handler));
    }

    private void __rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public CompletionStage<Void> rollback() {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__rollback((Handler<AsyncResult<Void>>)handler));
    }

    private Transaction __abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    public Transaction abortHandler(Consumer<Void> handler) {
        return this.__abortHandler(handler != null ? handler::accept : null);
    }

    private Transaction __query(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public CompletionStage<RowSet<Row>> query(String sql) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__query(sql, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    private Transaction __preparedQuery(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public CompletionStage<RowSet<Row>> preparedQuery(String sql) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__preparedQuery(sql, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    private Transaction __preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public CompletionStage<RowSet<Row>> preparedQuery(String sql, Tuple arguments) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__preparedQuery(sql, arguments, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    private Transaction __preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public CompletionStage<RowSet<Row>> preparedBatch(String sql, List<Tuple> batch) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__preparedBatch(sql, batch, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

