/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.amqp;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.amqp.AmqpReceiver;
import io.vertx.mutiny.amqp.AmqpSender;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    AmqpConnection() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private AmqpConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private AmqpConnection __close(Handler<AsyncResult<Void>> done) {
        this.delegate.close(done);
        return this;
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private AmqpConnection __createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpReceiver> createReceiver(String address) {
        return AsyncResultUni.toUni(handler -> this.__createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    public AmqpReceiver createReceiverAndAwait(String address) {
        return (AmqpReceiver)this.createReceiver(address).await().indefinitely();
    }

    private AmqpConnection __createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultUni.toUni(handler -> this.__createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    public AmqpReceiver createReceiverAndAwait(String address, AmqpReceiverOptions receiverOptions) {
        return (AmqpReceiver)this.createReceiver(address, receiverOptions).await().indefinitely();
    }

    private AmqpConnection __createDynamicReceiver(final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createDynamicReceiver((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpReceiver> createDynamicReceiver() {
        return AsyncResultUni.toUni(handler -> this.__createDynamicReceiver((Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    public AmqpReceiver createDynamicReceiverAndAwait() {
        return (AmqpReceiver)this.createDynamicReceiver().await().indefinitely();
    }

    private AmqpConnection __createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpSender> createSender(String address) {
        return AsyncResultUni.toUni(handler -> this.__createSender(address, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    public AmqpSender createSenderAndAwait(String address) {
        return (AmqpSender)this.createSender(address).await().indefinitely();
    }

    private AmqpConnection __createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultUni.toUni(handler -> this.__createSender(address, options, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    public AmqpSender createSenderAndAwait(String address, AmqpSenderOptions options) {
        return (AmqpSender)this.createSender(address, options).await().indefinitely();
    }

    private AmqpConnection __createAnonymousSender(final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createAnonymousSender((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpSender> createAnonymousSender() {
        return AsyncResultUni.toUni(handler -> this.__createAnonymousSender((Handler<AsyncResult<AmqpSender>>)handler));
    }

    public AmqpSender createAnonymousSenderAndAwait() {
        return (AmqpSender)this.createAnonymousSender().await().indefinitely();
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

