/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.amqp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.amqp.AmqpConnection;
import io.vertx.mutiny.amqp.AmqpReceiver;
import io.vertx.mutiny.amqp.AmqpSender;

@MutinyGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    public AmqpClient(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpClient)delegate;
    }

    AmqpClient() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.mutiny.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    @CheckReturnValue
    public Uni<AmqpConnection> connect() {
        return AsyncResultUni.toUni(connectionHandler -> this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
                if (ar.succeeded()) {
                    connectionHandler.handle((Object)Future.succeededFuture((Object)AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
                } else {
                    connectionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AmqpConnection connectAndAwait() {
        return (AmqpConnection)this.connect().await().indefinitely();
    }

    @Fluent
    public AmqpClient connectAndForget() {
        this.connect().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(closeHandler -> this.delegate.close(closeHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AmqpReceiver> createReceiver(String address) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AmqpReceiver createReceiverAndAwait(String address) {
        return (AmqpReceiver)this.createReceiver(address).await().indefinitely();
    }

    @Fluent
    public AmqpClient createReceiverAndForget(String address) {
        this.createReceiver(address).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AmqpReceiver createReceiverAndAwait(String address, AmqpReceiverOptions receiverOptions) {
        return (AmqpReceiver)this.createReceiver(address, receiverOptions).await().indefinitely();
    }

    @Fluent
    public AmqpClient createReceiverAndForget(String address, AmqpReceiverOptions receiverOptions) {
        this.createReceiver(address, receiverOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpSender> createSender(String address) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AmqpSender createSenderAndAwait(String address) {
        return (AmqpSender)this.createSender(address).await().indefinitely();
    }

    @Fluent
    public AmqpClient createSenderAndForget(String address) {
        this.createSender(address).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public AmqpSender createSenderAndAwait(String address, AmqpSenderOptions options) {
        return (AmqpSender)this.createSender(address, options).await().indefinitely();
    }

    @Fluent
    public AmqpClient createSenderAndForget(String address, AmqpSenderOptions options) {
        this.createSender(address, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

