package io.vertx.mutiny.amqp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.core.Future;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * AMQP Client entry point.
 * Use this interface to create an instance of {@link io.vertx.mutiny.amqp.AmqpClient} and connect to a broker and server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.amqp.AmqpClient.class)
public class AmqpClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<AmqpClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AmqpClient((io.vertx.amqp.AmqpClient) obj),
    AmqpClient::getDelegate
  );

  private final io.vertx.amqp.AmqpClient delegate;
  
  public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
    this.delegate = delegate;
  }

  public AmqpClient(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AmqpClient() {
    this.delegate = null;
  }

  public io.vertx.amqp.AmqpClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpClient that = (AmqpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param options the AMQP client options, may be <code>null</code> falling back to the default configuration
   * @return the created instances.
   */
  public static io.vertx.mutiny.amqp.AmqpClient create(io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.mutiny.amqp.AmqpClient ret = io.vertx.mutiny.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(options));
    return ret;
  }

  /**
   * @param vertx the vert.x instance, must not be <code>null</code>
   * @param options the AMQP options, may be @{code null} falling back to the default configuration
   * @return the AMQP client instance
   */
  public static io.vertx.mutiny.amqp.AmqpClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.mutiny.amqp.AmqpClient ret = io.vertx.mutiny.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpConnection> connect() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectionHandler -> {
        delegate.connect(new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
        if (ar.succeeded()) {
          connectionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
        } else {
          connectionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#connect}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the AmqpConnection instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpConnection connectAndAwait() { 
    return (io.vertx.mutiny.amqp.AmqpConnection) connect().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#connect} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#connect}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#connect} but you don't need to compose it with other operations.
   * @return the instance of AmqpClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpClient connectAndForget() { 
    connect().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(closeHandler -> {
        delegate.close(closeHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.mutiny.amqp.AmqpReceiver#connection}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpReceiver> createReceiver(String address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createReceiver(address, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the AmqpReceiver instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpReceiver createReceiverAndAwait(String address) { 
    return (io.vertx.mutiny.amqp.AmqpReceiver) createReceiver(address).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String)} but you don't need to compose it with other operations.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the instance of AmqpClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpClient createReceiverAndForget(String address) { 
    createReceiver(address).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.mutiny.amqp.AmqpReceiver#connection}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpReceiver> createReceiver(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createReceiver(address, receiverOptions, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String,AmqpReceiverOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the AmqpReceiver instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpReceiver createReceiverAndAwait(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return (io.vertx.mutiny.amqp.AmqpReceiver) createReceiver(address, receiverOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String,AmqpReceiverOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String,AmqpReceiverOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#createReceiver(String,AmqpReceiverOptions)} but you don't need to compose it with other operations.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the instance of AmqpClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpClient createReceiverAndForget(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    createReceiver(address, receiverOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpSender> createSender(String address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createSender(address, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the AmqpSender instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpSender createSenderAndAwait(String address) { 
    return (io.vertx.mutiny.amqp.AmqpSender) createSender(address).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String)} but you don't need to compose it with other operations.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the instance of AmqpClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpClient createSenderAndForget(String address) { 
    createSender(address).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpSender> createSender(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createSender(address, options, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String,AmqpSenderOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the AmqpSender instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpSender createSenderAndAwait(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return (io.vertx.mutiny.amqp.AmqpSender) createSender(address, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String,AmqpSenderOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String,AmqpSenderOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpClient#createSender(String,AmqpSenderOptions)} but you don't need to compose it with other operations.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the instance of AmqpClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpClient createSenderAndForget(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    createSender(address, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
    return arg != null ? new AmqpClient(arg) : null;
  }

}
