package io.vertx.mutiny.amqp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.proton.ProtonConnection;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Once connected to the broker or router, you get a connection. This connection is automatically opened.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<AmqpConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection) obj),
    AmqpConnection::getDelegate
  );

  private final io.vertx.amqp.AmqpConnection delegate;
  
  public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
    this.delegate = delegate;
  }

  public AmqpConnection(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AmqpConnection() {
    this.delegate = null;
  }

  public io.vertx.amqp.AmqpConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpConnection that = (AmqpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param handler the exception handler.
   * @return the connection
   */
  @Fluent
  private io.vertx.mutiny.amqp.AmqpConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the exception handler.
   * @return 
   */
  public io.vertx.mutiny.amqp.AmqpConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Closes the AMQP connection, i.e. allows the Close frame to be emitted.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(done -> {
        delegate.close(done);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#close} but you don't need to compose it with other operations.
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpReceiver> createReceiver(String address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createReceiver(address, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the AmqpReceiver instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpReceiver createReceiverAndAwait(String address) { 
    return (io.vertx.mutiny.amqp.AmqpReceiver) createReceiver(address).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String)} but you don't need to compose it with other operations.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createReceiverAndForget(String address) { 
    createReceiver(address).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpReceiver> createReceiver(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createReceiver(address, receiverOptions, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String,AmqpReceiverOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the AmqpReceiver instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpReceiver createReceiverAndAwait(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return (io.vertx.mutiny.amqp.AmqpReceiver) createReceiver(address, receiverOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String,AmqpReceiverOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String,AmqpReceiverOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createReceiver(String,AmqpReceiverOptions)} but you don't need to compose it with other operations.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createReceiverAndForget(String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    createReceiver(address, receiverOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
   * using the {@link io.vertx.mutiny.amqp.AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
   * reply address.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpReceiver> createDynamicReceiver() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createDynamicReceiver(new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createDynamicReceiver}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the AmqpReceiver instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpReceiver createDynamicReceiverAndAwait() { 
    return (io.vertx.mutiny.amqp.AmqpReceiver) createDynamicReceiver().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createDynamicReceiver} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createDynamicReceiver}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createDynamicReceiver} but you don't need to compose it with other operations.
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createDynamicReceiverAndForget() { 
    createDynamicReceiver().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpSender> createSender(String address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createSender(address, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the AmqpSender instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpSender createSenderAndAwait(String address) { 
    return (io.vertx.mutiny.amqp.AmqpSender) createSender(address).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String)} but you don't need to compose it with other operations.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createSenderAndForget(String address) { 
    createSender(address).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
   * {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpSender> createSender(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createSender(address, options, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String,AmqpSenderOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the AmqpSender instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpSender createSenderAndAwait(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return (io.vertx.mutiny.amqp.AmqpSender) createSender(address, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String,AmqpSenderOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String,AmqpSenderOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createSender(String,AmqpSenderOptions)} but you don't need to compose it with other operations.
   * @param address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
   * @param options The AMQP sender options
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createSenderAndForget(String address, io.vertx.amqp.AmqpSenderOptions options) { 
    createSender(address, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates an anonymous sender.
   * <p>
   * Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
   * an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
   * but you don't know the address, as the reply address is passed into the message you are going to receive.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.amqp.AmqpSender> createAnonymousSender() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.createAnonymousSender(new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the AmqpSender instance produced by the operation.
   */
  public io.vertx.mutiny.amqp.AmqpSender createAnonymousSenderAndAwait() { 
    return (io.vertx.mutiny.amqp.AmqpSender) createAnonymousSender().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#createAnonymousSender} but you don't need to compose it with other operations.
   * @return the instance of AmqpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpConnection createAnonymousSenderAndForget() { 
    createAnonymousSender().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return whether the connection has been disconnected.
   */
  public boolean isDisconnected() { 
    boolean ret = delegate.isDisconnected();
    return ret;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> closeFuture() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.closeFuture());}

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpConnection#closeFuture}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeFutureAndAwait() { 
    return closeFuture().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpConnection#closeFuture} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpConnection#closeFuture}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpConnection#closeFuture} but you don't need to compose it with other operations.
   */
  public void closeFutureAndForget() { 
    closeFuture().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @return the underlying ProtonConnection.
   */
  public io.vertx.proton.ProtonConnection unwrap() { 
    io.vertx.proton.ProtonConnection ret = delegate.unwrap();
    return ret;
  }

  public static  AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
    return arg != null ? new AmqpConnection(arg) : null;
  }

}
