package io.vertx.mutiny.amqp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.UUID;
import java.time.Instant;

/**
 * Builder to create a new {@link io.vertx.mutiny.amqp.AmqpMessage}.
 * <p>
 * Reference about the different metadata can be found on
 * <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
 * <p>
 * Note that the body is set using <code>withBodyAs*</code> method depending on the passed type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpMessageBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.amqp.AmqpMessageBuilder.class)
public class AmqpMessageBuilder {

  public static final io.smallrye.mutiny.vertx.TypeArg<AmqpMessageBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AmqpMessageBuilder((io.vertx.amqp.AmqpMessageBuilder) obj),
    AmqpMessageBuilder::getDelegate
  );

  private final io.vertx.amqp.AmqpMessageBuilder delegate;
  
  public AmqpMessageBuilder(io.vertx.amqp.AmqpMessageBuilder delegate) {
    this.delegate = delegate;
  }

  public AmqpMessageBuilder(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpMessageBuilder)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AmqpMessageBuilder() {
    this.delegate = null;
  }

  public io.vertx.amqp.AmqpMessageBuilder getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpMessageBuilder that = (AmqpMessageBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a new instance of {@link io.vertx.mutiny.amqp.AmqpMessageBuilder}
   */
  public static io.vertx.mutiny.amqp.AmqpMessageBuilder create() { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)io.vertx.amqp.AmqpMessageBuilder.create());
    return ret;
  }

  /**
   * @return the message.
   */
  public io.vertx.mutiny.amqp.AmqpMessage build() { 
    io.vertx.mutiny.amqp.AmqpMessage ret = io.vertx.mutiny.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)delegate.build());
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder priority(short priority) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.priority(priority));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder durable(boolean durable) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.durable(durable));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder ttl(long ttl) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.ttl(ttl));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder firstAcquirer(boolean first) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.firstAcquirer(first));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder deliveryCount(int count) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.deliveryCount(count));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder id(String id) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.id(id));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder address(String address) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.address(address));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder replyTo(String replyTo) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.replyTo(replyTo));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder correlationId(String correlationId) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.correlationId(correlationId));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withBody(String value) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBody(value));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withSymbolAsBody(String value) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withSymbolAsBody(value));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder subject(String subject) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.subject(subject));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder contentType(String ct) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.contentType(ct));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder contentEncoding(String ct) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.contentEncoding(ct));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder expiryTime(long expiry) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.expiryTime(expiry));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder creationTime(long ct) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.creationTime(ct));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder groupId(String gi) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.groupId(gi));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder replyToGroupId(String rt) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.replyToGroupId(rt));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder applicationProperties(JsonObject props) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.applicationProperties(props));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withBooleanAsBody(boolean v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBooleanAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withByteAsBody(byte v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withByteAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withShortAsBody(short v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withShortAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withIntegerAsBody(int v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withIntegerAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withLongAsBody(long v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withLongAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withFloatAsBody(float v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withFloatAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withDoubleAsBody(double v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withDoubleAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withCharAsBody(char c) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withCharAsBody(c));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withBufferAsBody(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBufferAsBody(buffer.getDelegate()));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withJsonObjectAsBody(JsonObject json) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withJsonObjectAsBody(json));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withJsonArrayAsBody(JsonArray json) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withJsonArrayAsBody(json));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withInstantAsBody(java.time.Instant v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withInstantAsBody(v));
    return ret;
  }

  public io.vertx.mutiny.amqp.AmqpMessageBuilder withUuidAsBody(java.util.UUID v) { 
    io.vertx.mutiny.amqp.AmqpMessageBuilder ret = io.vertx.mutiny.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withUuidAsBody(v));
    return ret;
  }

  public static  AmqpMessageBuilder newInstance(io.vertx.amqp.AmqpMessageBuilder arg) {
    return arg != null ? new AmqpMessageBuilder(arg) : null;
  }

}
