package io.vertx.mutiny.amqp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.proton.ProtonReceiver;
import io.vertx.core.Future;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Interface used to consume AMQP message as a stream of message.
 * Back pressure is implemented using AMQP credits.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpReceiver original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.amqp.AmqpReceiver.class)
public class AmqpReceiver implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.amqp.AmqpMessage> {

  public static final io.smallrye.mutiny.vertx.TypeArg<AmqpReceiver> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AmqpReceiver((io.vertx.amqp.AmqpReceiver) obj),
    AmqpReceiver::getDelegate
  );

  private final io.vertx.amqp.AmqpReceiver delegate;
  
  public AmqpReceiver(io.vertx.amqp.AmqpReceiver delegate) {
    this.delegate = delegate;
  }

  public AmqpReceiver(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpReceiver)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AmqpReceiver() {
    this.delegate = null;
  }

  public io.vertx.amqp.AmqpReceiver getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.amqp.AmqpMessage>(o1 -> io.vertx.mutiny.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpReceiver that = (AmqpReceiver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.amqp.AmqpMessage> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.amqp.AmqpMessage> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.amqp.AmqpReceiver __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.amqp.AmqpReceiver exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.amqp.AmqpReceiver __handler(Handler<io.vertx.mutiny.amqp.AmqpMessage> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)event)));
    return this;
  }

  public io.vertx.mutiny.amqp.AmqpReceiver handler(java.util.function.Consumer<io.vertx.mutiny.amqp.AmqpMessage> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.amqp.AmqpReceiver pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.amqp.AmqpReceiver resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.amqp.AmqpReceiver fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.amqp.AmqpReceiver __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.amqp.AmqpReceiver endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return the address, not <code>null</code>
   */
  public String address() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.address();
    cached_0 = ret;
    return ret;
  }

  /**
   * Closes the receiver.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpReceiver#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpReceiver#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpReceiver#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpReceiver#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the connection having created the receiver.
   */
  public io.vertx.mutiny.amqp.AmqpConnection connection() { 
    io.vertx.mutiny.amqp.AmqpConnection ret = io.vertx.mutiny.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the underlying ProtonReceiver.
   */
  public io.vertx.proton.ProtonReceiver unwrap() { 
    io.vertx.proton.ProtonReceiver ret = delegate.unwrap();
    return ret;
  }

  private String cached_0;
  private Multi<io.vertx.mutiny.amqp.AmqpMessage> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.amqp.AmqpMessage> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.amqp.AmqpMessage, io.vertx.mutiny.amqp.AmqpMessage> conv = io.vertx.mutiny.amqp.AmqpMessage::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.amqp.AmqpMessage> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.amqp.AmqpMessage> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  AmqpReceiver newInstance(io.vertx.amqp.AmqpReceiver arg) {
    return arg != null ? new AmqpReceiver(arg) : null;
  }

}
