package io.vertx.mutiny.amqp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.proton.ProtonSender;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * AMQP Sender interface used to send messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpSender original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.amqp.AmqpSender.class)
public class AmqpSender implements io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> {

  public static final io.smallrye.mutiny.vertx.TypeArg<AmqpSender> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AmqpSender((io.vertx.amqp.AmqpSender) obj),
    AmqpSender::getDelegate
  );

  private final io.vertx.amqp.AmqpSender delegate;
  
  public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
    this.delegate = delegate;
  }

  public AmqpSender(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpSender)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AmqpSender() {
    this.delegate = null;
  }

  public io.vertx.amqp.AmqpSender getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.amqp.AmqpMessage>(o1 -> io.vertx.mutiny.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpSender that = (AmqpSender) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.amqp.AmqpMessage> subscriber;

  @CheckReturnValue
  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.amqp.AmqpMessage> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.mutiny.amqp.AmqpMessage::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.amqp.AmqpMessage arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(arg1 -> {
        delegate.write(arg0.getDelegate(), arg1);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.amqp.AmqpMessage arg0) { 
    return (Void) write(arg0).await().indefinitely();
  }

  public void writeAndForget(io.vertx.mutiny.amqp.AmqpMessage arg0) { 
    write(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(arg0 -> {
        delegate.end(arg0);
    });
  }

  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.amqp.AmqpMessage data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(data.getDelegate(), handler);
    });
  }

  public Void endAndAwait(io.vertx.mutiny.amqp.AmqpMessage data) { 
    return (Void) end(data).await().indefinitely();
  }

  public void endAndForget(io.vertx.mutiny.amqp.AmqpMessage data) { 
    end(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> __drainHandler(Handler<Void> arg0) { 
    delegate.drainHandler(arg0);
    return this;
  }

  public io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.amqp.AmqpMessage> drainHandler(java.lang.Runnable arg0) {
    return __drainHandler(ignored -> arg0.run()
);
  }

  @Fluent
  private io.vertx.mutiny.amqp.AmqpSender __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.amqp.AmqpSender exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.amqp.AmqpSender setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpSender send(io.vertx.mutiny.amqp.AmqpMessage message) { 
    delegate.send(message.getDelegate());
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message the message, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendWithAck(io.vertx.mutiny.amqp.AmqpMessage message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(acknowledgementHandler -> {
        delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpSender#sendWithAck(io.vertx.mutiny.amqp.AmqpMessage)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message the message, must not be <code>null</code>
   * @return the Void instance produced by the operation.
   */
  public Void sendWithAckAndAwait(io.vertx.mutiny.amqp.AmqpMessage message) { 
    return (Void) sendWithAck(message).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpSender#sendWithAck(io.vertx.mutiny.amqp.AmqpMessage)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpSender#sendWithAck(io.vertx.mutiny.amqp.AmqpMessage)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpSender#sendWithAck(io.vertx.mutiny.amqp.AmqpMessage)} but you don't need to compose it with other operations.
   * @param message the message, must not be <code>null</code>
   * @return the instance of AmqpSender to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.amqp.AmqpSender sendWithAckAndForget(io.vertx.mutiny.amqp.AmqpMessage message) { 
    sendWithAck(message).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the sender.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.amqp.AmqpSender#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.amqp.AmqpSender#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.amqp.AmqpSender#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.amqp.AmqpSender#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the configured address.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * @return the connection having created the sender.
   */
  public io.vertx.mutiny.amqp.AmqpConnection connection() { 
    io.vertx.mutiny.amqp.AmqpConnection ret = io.vertx.mutiny.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the remaining credit, 0 is none.
   */
  public long remainingCredits() { 
    long ret = delegate.remainingCredits();
    return ret;
  }

  /**
   * @return the underlying ProtonSender.
   */
  public io.vertx.proton.ProtonSender unwrap() { 
    io.vertx.proton.ProtonSender ret = delegate.unwrap();
    return ret;
  }

  public static  AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
    return arg != null ? new AmqpSender(arg) : null;
  }

}
