package io.vertx.mutiny.ext.auth;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Map;

/**
 * Hashing Strategy manager.
 *
 * This class will load system provided hashing strategies and algorithms.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.HashingStrategy original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.HashingStrategy.class)
public class HashingStrategy implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<HashingStrategy> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HashingStrategy((io.vertx.ext.auth.HashingStrategy) obj),
    HashingStrategy::getDelegate
  );

  private final io.vertx.ext.auth.HashingStrategy delegate;
  
  public HashingStrategy(io.vertx.ext.auth.HashingStrategy delegate) {
    this.delegate = delegate;
  }

  public HashingStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.HashingStrategy)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HashingStrategy() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.auth.HashingStrategy getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashingStrategy that = (HashingStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a Hashing Strategy capable of hashing using the available algorithms
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.HashingStrategy load() { 
    io.vertx.mutiny.ext.auth.HashingStrategy ret = io.vertx.mutiny.ext.auth.HashingStrategy.newInstance((io.vertx.ext.auth.HashingStrategy)io.vertx.ext.auth.HashingStrategy.load());
    return ret;
  }

  /**
   * @param id the algorithm id
   * @param params the algorithm specific parameters
   * @param salt the given salt
   * @param password the given password
   * @return the hashed string
   * @deprecated   */
  @Deprecated
  public String hash(String id, java.util.Map<String, String> params, String salt, String password) { 
    String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * @param hash the hash to verify
   * @param password the password to test against
   * @return boolean
   * @deprecated   */
  @Deprecated
  public boolean verify(String hash, String password) { 
    boolean ret = delegate.verify(hash, password);
    return ret;
  }

  /**
   * @param id the algorithm id
   * @return the algorithm
   * @deprecated   */
  @Deprecated
  public io.vertx.mutiny.ext.auth.HashingAlgorithm get(String id) { 
    io.vertx.mutiny.ext.auth.HashingAlgorithm ret = io.vertx.mutiny.ext.auth.HashingAlgorithm.newInstance((io.vertx.ext.auth.HashingAlgorithm)delegate.get(id));
    return ret;
  }

  /**
   * @param id the algorithm id
   * @param algorithm the implementation
   * @return self
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.HashingStrategy put(String id, io.vertx.mutiny.ext.auth.HashingAlgorithm algorithm) { 
    delegate.put(id, algorithm.getDelegate());
    return this;
  }

  public static  HashingStrategy newInstance(io.vertx.ext.auth.HashingStrategy arg) {
    return arg != null ? new HashingStrategy(arg) : null;
  }

}
