package io.vertx.mutiny.ext.auth;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A secure non blocking random number generator isolated to the current context. The PRNG is bound to the vert.x
 * context and setup to close when the context shuts down.
 * <p>
 * When applicable, use of VertxContextPRNG rather than create new PRNG objects is helpful to keep the system entropy
 * usage to the minimum avoiding potential blocking across the application.
 * <p>
 * The use of VertxContextPRNG is particularly appropriate when multiple handlers use random numbers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.VertxContextPRNG original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.VertxContextPRNG.class)
public class VertxContextPRNG extends io.vertx.mutiny.ext.auth.prng.VertxContextPRNG implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<VertxContextPRNG> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new VertxContextPRNG((io.vertx.ext.auth.VertxContextPRNG) obj),
    VertxContextPRNG::getDelegate
  );

  private final io.vertx.ext.auth.VertxContextPRNG delegate;
  
  public VertxContextPRNG(io.vertx.ext.auth.VertxContextPRNG delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public VertxContextPRNG(Object delegate) {
    super((io.vertx.ext.auth.VertxContextPRNG)delegate);
    this.delegate = (io.vertx.ext.auth.VertxContextPRNG)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  VertxContextPRNG() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.auth.VertxContextPRNG getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxContextPRNG that = (VertxContextPRNG) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return A secure non blocking random number generator.
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.VertxContextPRNG current() { 
    io.vertx.mutiny.ext.auth.VertxContextPRNG ret = io.vertx.mutiny.ext.auth.VertxContextPRNG.newInstance((io.vertx.ext.auth.VertxContextPRNG)io.vertx.ext.auth.VertxContextPRNG.current());
    return ret;
  }

  /**
   * @param vertx a Vert.x instance.
   * @return A secure non blocking random number generator.
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.VertxContextPRNG current(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.VertxContextPRNG ret = io.vertx.mutiny.ext.auth.VertxContextPRNG.newInstance((io.vertx.ext.auth.VertxContextPRNG)io.vertx.ext.auth.VertxContextPRNG.current(vertx.getDelegate()));
    return ret;
  }

  public static  VertxContextPRNG newInstance(io.vertx.ext.auth.VertxContextPRNG arg) {
    return arg != null ? new VertxContextPRNG(arg) : null;
  }

}
