package io.vertx.mutiny.ext.auth.oauth2.authorization;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * Scope is a mechanism in OAuth 2.0 to limit an application's access to a user's account.
 * An application can request one or more scopes, this information is then presented to the
 * user in the consent screen, and the access token issued to the application will be
 * limited to the scopes granted.
 *
 * The OAuth spec allows the authorization server or user to modify the scopes granted to
 * the application compared to what is requested, although there are not many examples of
 * services doing this in practice.
 *
 * OAuth2 does not define any particular values for scopes, since it is highly dependent
 * on the service's internal architecture and needs.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.class)
public class ScopeAuthorization extends io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<ScopeAuthorization> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ScopeAuthorization((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization) obj),
    ScopeAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization delegate;
  
  public ScopeAuthorization(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ScopeAuthorization(Object delegate) {
    super((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ScopeAuthorization() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScopeAuthorization that = (ScopeAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a AuthorizationProvider
   */
  public static io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization create() { 
    io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create());
    return ret;
  }

  /**
   * @param scopeSeparator the scope separator e.g.: <code>" "</code>, <code>","</code>, <code>"+"</code>
   * @return a AuthorizationProvider
   */
  public static io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization create(String scopeSeparator) { 
    io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create(scopeSeparator));
    return ret;
  }

  /**
   * @param scopeSeparator the scope separator e.g.: <code>" "</code>, <code>","</code>, <code>"+"</code>
   * @param claimKey the scope claim key e.g.: <code>"scp"</code>, <code>"scope"</code>
   * @return a AuthorizationProvider
   */
  public static io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization create(String scopeSeparator, String claimKey) { 
    io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.mutiny.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create(scopeSeparator, claimKey));
    return ret;
  }

  /**
   * @return the separator.
   */
  public String separator() { 
    String ret = delegate.separator();
    return ret;
  }

  /**
   * @return the claim key.
   */
  public String claimKey() { 
    String ret = delegate.claimKey();
    return ret;
  }

  /**
   * @param scopes a list of scopes
   * @return concatenated string.
   */
  public String encode(List<String> scopes) { 
    String ret = delegate.encode(scopes);
    return ret;
  }

  public static  ScopeAuthorization newInstance(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization arg) {
    return arg != null ? new ScopeAuthorization(arg) : null;
  }

}
