package io.vertx.mutiny.ext.auth.oauth2.providers;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Simplified factory to create an {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth} for Google.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.GoogleAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.providers.GoogleAuth.class)
public class GoogleAuth extends io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth {

  public static final io.smallrye.mutiny.vertx.TypeArg<GoogleAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new GoogleAuth((io.vertx.ext.auth.oauth2.providers.GoogleAuth) obj),
    GoogleAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate;
  
  public GoogleAuth(io.vertx.ext.auth.oauth2.providers.GoogleAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public GoogleAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.GoogleAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  GoogleAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.providers.GoogleAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GoogleAuth that = (GoogleAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String clientId, String clientSecret) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * @param vertx 
   * @param clientId the client id given to you by Google
   * @param clientSecret the client secret given to you by Google
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String clientId, String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth> discover(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.ext.auth.oauth2.providers.GoogleAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.GoogleAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param config the initial config
   * @return the OAuth2Auth instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth discoverAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return (io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth) discover(vertx, config).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.GoogleAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.providers.GoogleAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.providers.GoogleAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param config the initial config
   */
  public static void discoverAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    discover(vertx, config).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, JsonObject serviceAccountJson) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson));
    return ret;
  }

  /**
   * @param vertx 
   * @param serviceAccountJson the configuration json file from your Google API page
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, JsonObject serviceAccountJson, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GoogleAuth.create(vertx.getDelegate(), serviceAccountJson, httpClientOptions));
    return ret;
  }

  public static  GoogleAuth newInstance(io.vertx.ext.auth.oauth2.providers.GoogleAuth arg) {
    return arg != null ? new GoogleAuth(arg) : null;
  }

}
