package io.vertx.mutiny.ext.auth.oauth2.providers;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.HttpClientOptions;

/**
 * Simplified factory to create an  for CloudFoundry UAA.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.class)
public class CloudFoundryAuth {

  public static final io.smallrye.mutiny.vertx.TypeArg<CloudFoundryAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CloudFoundryAuth((io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth) obj),
    CloudFoundryAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth delegate;
  
  public CloudFoundryAuth(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth delegate) {
    this.delegate = delegate;
  }

  public CloudFoundryAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CloudFoundryAuth() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CloudFoundryAuth that = (CloudFoundryAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param clientId the client id given to you by CloudFoundry UAA
   * @param clientSecret the client secret given to you by CloudFoundry UAA
   * @param uuaURL the url to your UUA server instance
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String clientId, String clientSecret, String uuaURL) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.create(vertx.getDelegate(), clientId, clientSecret, uuaURL));
    return ret;
  }

  /**
   * @param vertx 
   * @param clientId the client id given to you by CloudFoundry UAA
   * @param clientSecret the client secret given to you by CloudFoundry UAA
   * @param uuaURL the url to your UUA server instance
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String clientId, String clientSecret, String uuaURL, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth.create(vertx.getDelegate(), clientId, clientSecret, uuaURL, httpClientOptions));
    return ret;
  }

  public static  CloudFoundryAuth newInstance(io.vertx.ext.auth.oauth2.providers.CloudFoundryAuth arg) {
    return arg != null ? new CloudFoundryAuth(arg) : null;
  }

}
