package io.vertx.mutiny.ext.auth.oauth2.providers;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Simplified factory to create an  for Keycloak.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.KeycloakAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.class)
public class KeycloakAuth extends io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth {

  public static final io.smallrye.mutiny.vertx.TypeArg<KeycloakAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KeycloakAuth((io.vertx.ext.auth.oauth2.providers.KeycloakAuth) obj),
    KeycloakAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate;
  
  public KeycloakAuth(io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public KeycloakAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.KeycloakAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.KeycloakAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KeycloakAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.providers.KeycloakAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeycloakAuth that = (KeycloakAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, JsonObject config) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, JsonObject config) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, JsonObject config, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config, httpClientOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, JsonObject config, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth> discover(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.ext.auth.oauth2.providers.KeycloakAuth.discover(vertx.getDelegate(), config, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.KeycloakAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param config the initial config
   * @return the OAuth2Auth instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth discoverAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return (io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth) discover(vertx, config).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.KeycloakAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.providers.KeycloakAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.providers.KeycloakAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param config the initial config
   */
  public static void discoverAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    discover(vertx, config).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  KeycloakAuth newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth arg) {
    return arg != null ? new KeycloakAuth(arg) : null;
  }

}
