package io.vertx.mutiny.ext.auth.oauth2.providers;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Simplified factory to create an {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth} for OpenID Connect.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.class)
public class OpenIDConnectAuth implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<OpenIDConnectAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OpenIDConnectAuth((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth) obj),
    OpenIDConnectAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate;
  
  public OpenIDConnectAuth(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate) {
    this.delegate = delegate;
  }

  public OpenIDConnectAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OpenIDConnectAuth() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenIDConnectAuth that = (OpenIDConnectAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth> discover(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.discover(vertx.getDelegate(), config, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @return the OAuth2Auth instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth discoverAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return (io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth) discover(vertx, config).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth#discover(io.vertx.mutiny.core.Vertx,OAuth2Options)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   */
  public static void discoverAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    discover(vertx, config).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  OpenIDConnectAuth newInstance(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth arg) {
    return arg != null ? new OpenIDConnectAuth(arg) : null;
  }

}
