package io.vertx.mutiny.ext.auth.oauth2;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Factory interface for creating OAuth2 based {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2Auth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<OAuth2Auth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth) obj),
    OAuth2Auth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;
  
  public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OAuth2Auth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OAuth2Auth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2Auth that = (OAuth2Auth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vertx instance
   * @return the auth provider
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth ret = io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Retrieve the public server JSON Web Key (JWK) required to verify the authenticity
   * of issued ID and access tokens. The provider will refresh the keys according to:
   * https://openid.net/specs/openid-connect-core-1_0.html#RotateEncKeys
   *
   * This means that the provider will look at the cache headers and will refresh when
   * the max-age is reached. If the server does not return any cache headers it shall
   * be up to the end user to call this method to refresh.
   *
   * To avoid the refresh to happen too late, this means that they keys will be invalid,
   * if the {@link io.vertx.ext.auth.oauth2.OAuth2Options} {@link io.vertx.ext.auth.JWTOptions} config contains a
   * positive leeway, it will be used to request the refresh ahead of time.
   *
   * Key rotation can be controled by {@link io.vertx.ext.auth.oauth2.OAuth2Options}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> jWKSet() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.jWKSet(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#jWKSet}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void jWKSetAndAwait() { 
    return (Void) jWKSet().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#jWKSet} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#jWKSet}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#jWKSet} but you don't need to compose it with other operations.
   * @return the instance of OAuth2Auth to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth jWKSetAndForget() { 
    jWKSet().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler 
   * @return Future result.
   */
  @Fluent
  private io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth __missingKeyHandler(Handler<String> handler) { 
    delegate.missingKeyHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth missingKeyHandler(java.util.function.Consumer<String> handler) {
    return __missingKeyHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param params extra params to be included in the final URL.
   * @return the url to be used to authorize the user.
   */
  public String authorizeURL(JsonObject params) { 
    String ret = delegate.authorizeURL(params);
    return ret;
  }

  /**
   * Refresh the current User (access token).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user the user (access token) to be refreshed.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.User> refresh(io.vertx.mutiny.ext.auth.User user) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.refresh(user.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#refresh(io.vertx.mutiny.ext.auth.User)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user the user (access token) to be refreshed.
   * @return the User instance produced by the operation.
   */
  public io.vertx.mutiny.ext.auth.User refreshAndAwait(io.vertx.mutiny.ext.auth.User user) { 
    return (io.vertx.mutiny.ext.auth.User) refresh(user).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#refresh(io.vertx.mutiny.ext.auth.User)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#refresh(io.vertx.mutiny.ext.auth.User)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#refresh(io.vertx.mutiny.ext.auth.User)} but you don't need to compose it with other operations.
   * @param user the user (access token) to be refreshed.
   * @return the instance of OAuth2Auth to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth refreshAndForget(io.vertx.mutiny.ext.auth.User user) { 
    refresh(user).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Revoke an obtained access or refresh token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user the user (access token) to revoke.
   * @param tokenType the token type (either access_token or refresh_token).
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> revoke(io.vertx.mutiny.ext.auth.User user, String tokenType) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.revoke(user.getDelegate(), tokenType, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user the user (access token) to revoke.
   * @param tokenType the token type (either access_token or refresh_token).
   * @return the Void instance produced by the operation.
   */
  public Void revokeAndAwait(io.vertx.mutiny.ext.auth.User user, String tokenType) { 
    return (Void) revoke(user, tokenType).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User,String)} but you don't need to compose it with other operations.
   * @param user the user (access token) to revoke.
   * @param tokenType the token type (either access_token or refresh_token).
   * @return the instance of OAuth2Auth to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth revokeAndForget(io.vertx.mutiny.ext.auth.User user, String tokenType) { 
    revoke(user, tokenType).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Revoke an obtained access token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user the user (access token) to revoke.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> revoke(io.vertx.mutiny.ext.auth.User user) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.revoke(user.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user the user (access token) to revoke.
   * @return the Void instance produced by the operation.
   */
  public Void revokeAndAwait(io.vertx.mutiny.ext.auth.User user) { 
    return (Void) revoke(user).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#revoke(io.vertx.mutiny.ext.auth.User)} but you don't need to compose it with other operations.
   * @param user the user (access token) to revoke.
   * @return the instance of OAuth2Auth to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth revokeAndForget(io.vertx.mutiny.ext.auth.User user) { 
    revoke(user).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Retrieve profile information and other attributes for a logged-in end-user. More info <a href="https://openid.net/specs/openid-connect-core-1_0.html#UserInfo">https://openid.net/specs/openid-connect-core-1_0.html#UserInfo</a>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user the user (access token) to fetch the user info.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> userInfo(io.vertx.mutiny.ext.auth.User user) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.userInfo(user.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#userInfo(io.vertx.mutiny.ext.auth.User)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user the user (access token) to fetch the user info.
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject userInfoAndAwait(io.vertx.mutiny.ext.auth.User user) { 
    return (JsonObject) userInfo(user).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#userInfo(io.vertx.mutiny.ext.auth.User)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#userInfo(io.vertx.mutiny.ext.auth.User)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth#userInfo(io.vertx.mutiny.ext.auth.User)} but you don't need to compose it with other operations.
   * @param user the user (access token) to fetch the user info.
   * @return the instance of OAuth2Auth to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth userInfoAndForget(io.vertx.mutiny.ext.auth.User user) { 
    userInfo(user).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param user the user to generate the url for
   * @param params extra parameters to apply to the url
   * @return the url to end the session.
   */
  public String endSessionURL(io.vertx.mutiny.ext.auth.User user, JsonObject params) { 
    String ret = delegate.endSessionURL(user.getDelegate(), params);
    return ret;
  }

  /**
   * @param user the user to generate the url for
   * @return the url to end the session.
   */
  public String endSessionURL(io.vertx.mutiny.ext.auth.User user) { 
    String ret = delegate.endSessionURL(user.getDelegate());
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
    return arg != null ? new OAuth2Auth(arg) : null;
  }

}
