package io.vertx.mutiny.ext.auth.otp.totp;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpKey;
import java.util.function.Function;
import io.vertx.core.Future;
import io.vertx.ext.auth.otp.totp.TotpAuthOptions;

/**
 * An extension of AuthProvider which uses the one time passwords based on time to perform authentication.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.otp.totp.TotpAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.otp.totp.TotpAuth.class)
public class TotpAuth extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<TotpAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TotpAuth((io.vertx.ext.auth.otp.totp.TotpAuth) obj),
    TotpAuth::getDelegate
  );

  private final io.vertx.ext.auth.otp.totp.TotpAuth delegate;
  
  public TotpAuth(io.vertx.ext.auth.otp.totp.TotpAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public TotpAuth(Object delegate) {
    super((io.vertx.ext.auth.otp.totp.TotpAuth)delegate);
    this.delegate = (io.vertx.ext.auth.otp.totp.TotpAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  TotpAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.otp.totp.TotpAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TotpAuth that = (TotpAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.otp.totp.TotpAuth authenticatorFetcher(Function<String, io.smallrye.mutiny.Uni<io.vertx.ext.auth.otp.Authenticator>> fetcher) { 
    delegate.authenticatorFetcher(new java.util.function.Function<String,io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.otp.Authenticator> apply(String arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 fetcher.apply(arg)
            );
         }
     });
    return this;
  }

  /**
   * @param updater updater function.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.otp.totp.TotpAuth authenticatorUpdater(Function<io.vertx.ext.auth.otp.Authenticator, io.smallrye.mutiny.Uni<Void>> updater) { 
    delegate.authenticatorUpdater(new java.util.function.Function<io.vertx.ext.auth.otp.Authenticator,io.vertx.core.Future<java.lang.Void>>() {
      public io.vertx.core.Future<Void> apply(io.vertx.ext.auth.otp.Authenticator arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 updater.apply(arg)
            );
         }
     });
    return this;
  }

  /**
   * Creating authenticator from user id and key.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id id user.
   * @param otpKey key of user used for auth.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.auth.otp.Authenticator> createAuthenticator(String id, io.vertx.ext.auth.otp.OtpKey otpKey) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.createAuthenticator(id, otpKey));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth#createAuthenticator(String,OtpKey)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id id user.
   * @param otpKey key of user used for auth.
   * @return the Authenticator instance produced by the operation.
   */
  public io.vertx.ext.auth.otp.Authenticator createAuthenticatorAndAwait(String id, io.vertx.ext.auth.otp.OtpKey otpKey) { 
    return createAuthenticator(id, otpKey).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth#createAuthenticator(String,OtpKey)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth#createAuthenticator(String,OtpKey)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth#createAuthenticator(String,OtpKey)} but you don't need to compose it with other operations.
   * @param id id user.
   * @param otpKey key of user used for auth.
   */
  public void createAuthenticatorAndForget(String id, io.vertx.ext.auth.otp.OtpKey otpKey) { 
    createAuthenticator(id, otpKey).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  /**
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, String issuer, String user, String label) { 
    String ret = delegate.generateUri(otpKey, issuer, user, label);
    return ret;
  }

  /**
   * @param otpKey user key.
   * @param issuer issuer of key.
   * @param user display name of user account.
   * @return uri containing the key.
   */
  public String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, String issuer, String user) { 
    String ret = delegate.generateUri(otpKey, issuer, user);
    return ret;
  }

  /**
   * @param otpKey user key.
   * @param label the label to identify which account a key is associated with.
   * @return uri containing the key.
   */
  public String generateUri(io.vertx.ext.auth.otp.OtpKey otpKey, String label) { 
    String ret = delegate.generateUri(otpKey, label);
    return ret;
  }

  /**
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.mutiny.ext.auth.otp.totp.TotpAuth create() { 
    io.vertx.mutiny.ext.auth.otp.totp.TotpAuth ret = io.vertx.mutiny.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create());
    return ret;
  }

  /**
   * @param totpAuthOptions the config.
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.otp.totp.TotpAuth}.
   */
  public static io.vertx.mutiny.ext.auth.otp.totp.TotpAuth create(io.vertx.ext.auth.otp.totp.TotpAuthOptions totpAuthOptions) { 
    io.vertx.mutiny.ext.auth.otp.totp.TotpAuth ret = io.vertx.mutiny.ext.auth.otp.totp.TotpAuth.newInstance((io.vertx.ext.auth.otp.totp.TotpAuth)io.vertx.ext.auth.otp.totp.TotpAuth.create(totpAuthOptions));
    return ret;
  }

  public static  TotpAuth newInstance(io.vertx.ext.auth.otp.totp.TotpAuth arg) {
    return arg != null ? new TotpAuth(arg) : null;
  }

}
