package io.vertx.mutiny.ext.auth.webauthn;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.core.Future;
import java.util.function.Function;
import java.util.List;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Factory interface for creating WebAuthN based {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.webauthn.WebAuthn original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.webauthn.WebAuthn.class)
public class WebAuthn extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebAuthn> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebAuthn((io.vertx.ext.auth.webauthn.WebAuthn) obj),
    WebAuthn::getDelegate
  );

  private final io.vertx.ext.auth.webauthn.WebAuthn delegate;
  
  public WebAuthn(io.vertx.ext.auth.webauthn.WebAuthn delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WebAuthn(Object delegate) {
    super((io.vertx.ext.auth.webauthn.WebAuthn)delegate);
    this.delegate = (io.vertx.ext.auth.webauthn.WebAuthn)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebAuthn() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.webauthn.WebAuthn getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthn that = (WebAuthn) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vertx instance.
   * @return the auth provider.
   */
  public static io.vertx.mutiny.ext.auth.webauthn.WebAuthn create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.webauthn.WebAuthn ret = io.vertx.mutiny.ext.auth.webauthn.WebAuthn.newInstance((io.vertx.ext.auth.webauthn.WebAuthn)io.vertx.ext.auth.webauthn.WebAuthn.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vertx instance.
   * @param options the custom options to the provider.
   * @return the auth provider.
   */
  public static io.vertx.mutiny.ext.auth.webauthn.WebAuthn create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.webauthn.WebAuthnOptions options) { 
    io.vertx.mutiny.ext.auth.webauthn.WebAuthn ret = io.vertx.mutiny.ext.auth.webauthn.WebAuthn.newInstance((io.vertx.ext.auth.webauthn.WebAuthn)io.vertx.ext.auth.webauthn.WebAuthn.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param user - the user object with name and optionally displayName and icon
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> createCredentialsOptions(JsonObject user) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.createCredentialsOptions(user, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#createCredentialsOptions(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param user - the user object with name and optionally displayName and icon
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject createCredentialsOptionsAndAwait(JsonObject user) { 
    return (JsonObject) createCredentialsOptions(user).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#createCredentialsOptions(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#createCredentialsOptions(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#createCredentialsOptions(JsonObject)} but you don't need to compose it with other operations.
   * @param user - the user object with name and optionally displayName and icon
   * @return the instance of WebAuthn to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.webauthn.WebAuthn createCredentialsOptionsAndForget(JsonObject user) { 
    createCredentialsOptions(user).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   *
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name the unique user identified
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> getCredentialsOptions(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getCredentialsOptions(name, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#getCredentialsOptions(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name the unique user identified
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject getCredentialsOptionsAndAwait(String name) { 
    return (JsonObject) getCredentialsOptions(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#getCredentialsOptions(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#getCredentialsOptions(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.webauthn.WebAuthn#getCredentialsOptions(String)} but you don't need to compose it with other operations.
   * @param name the unique user identified
   * @return the instance of WebAuthn to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.webauthn.WebAuthn getCredentialsOptionsAndForget(String name) { 
    getCredentialsOptions(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param fetcher fetcher function.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.webauthn.WebAuthn authenticatorFetcher(Function<io.vertx.ext.auth.webauthn.Authenticator, io.smallrye.mutiny.Uni<List<io.vertx.ext.auth.webauthn.Authenticator>>> fetcher) { 
    delegate.authenticatorFetcher(new java.util.function.Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.util.List<io.vertx.ext.auth.webauthn.Authenticator>>>() {
      public io.vertx.core.Future<List<io.vertx.ext.auth.webauthn.Authenticator>> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 fetcher.apply(arg)
            );
         }
     });
    return this;
  }

  /**
   * @param updater updater function.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.webauthn.WebAuthn authenticatorUpdater(Function<io.vertx.ext.auth.webauthn.Authenticator, io.smallrye.mutiny.Uni<Void>> updater) { 
    delegate.authenticatorUpdater(new java.util.function.Function<io.vertx.ext.auth.webauthn.Authenticator,io.vertx.core.Future<java.lang.Void>>() {
      public io.vertx.core.Future<Void> apply(io.vertx.ext.auth.webauthn.Authenticator arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 updater.apply(arg)
            );
         }
     });
    return this;
  }

  /**
   * @return the MDS instance.
   */
  public io.vertx.mutiny.ext.auth.webauthn.MetaDataService metaDataService() { 
    io.vertx.mutiny.ext.auth.webauthn.MetaDataService ret = io.vertx.mutiny.ext.auth.webauthn.MetaDataService.newInstance((io.vertx.ext.auth.webauthn.MetaDataService)delegate.metaDataService());
    return ret;
  }

  public static  WebAuthn newInstance(io.vertx.ext.auth.webauthn.WebAuthn arg) {
    return arg != null ? new WebAuthn(arg) : null;
  }

}
