package io.vertx.mutiny.cassandra;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import com.datastax.oss.driver.api.core.cql.Row;
import io.vertx.core.Future;

/**
 * A  for  consumption.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraRowStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.cassandra.CassandraRowStream.class)
public class CassandraRowStream implements io.vertx.mutiny.core.streams.ReadStream<Row> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CassandraRowStream> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CassandraRowStream((io.vertx.cassandra.CassandraRowStream) obj),
    CassandraRowStream::getDelegate
  );

  private final io.vertx.cassandra.CassandraRowStream delegate;
  
  public CassandraRowStream(io.vertx.cassandra.CassandraRowStream delegate) {
    this.delegate = delegate;
  }

  public CassandraRowStream(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraRowStream)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CassandraRowStream() {
    this.delegate = null;
  }

  public io.vertx.cassandra.CassandraRowStream getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraRowStream that = (CassandraRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<com.datastax.oss.driver.api.core.cql.Row> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<com.datastax.oss.driver.api.core.cql.Row> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.cassandra.CassandraRowStream __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.cassandra.CassandraRowStream exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.cassandra.CassandraRowStream pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.cassandra.CassandraRowStream resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.cassandra.CassandraRowStream __endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.mutiny.cassandra.CassandraRowStream endHandler(java.lang.Runnable handler) {
    return __endHandler(ignored -> handler.run()
);
  }

  @Fluent
  public io.vertx.mutiny.cassandra.CassandraRowStream fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.cassandra.CassandraRowStream __handler(Handler<com.datastax.oss.driver.api.core.cql.Row> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.mutiny.cassandra.CassandraRowStream handler(java.util.function.Consumer<com.datastax.oss.driver.api.core.cql.Row> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo executionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.executionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions columnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.columnDefinitions();
    return ret;
  }

  private Multi<Row> multi;

  @CheckReturnValue
  public synchronized Multi<Row> toMulti() {
    if (multi == null) {
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(this.getDelegate());    }
    return multi;
  }

  public java.lang.Iterable<Row> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<Row> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  CassandraRowStream newInstance(io.vertx.cassandra.CassandraRowStream arg) {
    return arg != null ? new CassandraRowStream(arg) : null;
  }

}
