package io.vertx.mutiny.cassandra;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.Future;
import java.util.List;
import io.vertx.core.AsyncResult;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.vertx.core.Handler;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;

/**
 * Eclipse Vert.x Cassandra client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<CassandraClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CassandraClient((io.vertx.cassandra.CassandraClient) obj),
    CassandraClient::getDelegate
  );

  private final io.vertx.cassandra.CassandraClient delegate;
  
  public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
    this.delegate = delegate;
  }

  public CassandraClient(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CassandraClient() {
    this.delegate = null;
  }

  public io.vertx.cassandra.CassandraClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraClient that = (CassandraClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @return 
   */
  public static io.vertx.mutiny.cassandra.CassandraClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.mutiny.cassandra.CassandraClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx 
   * @return 
   */
  public static io.vertx.mutiny.cassandra.CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx 
   * @param clientName 
   * @return 
   */
  public static io.vertx.mutiny.cassandra.CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName));
    return ret;
  }

  /**
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.cassandra.CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param clientName the shared client name
   * @param options the options
   * @return the client
   */
  public static io.vertx.mutiny.cassandra.CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.mutiny.cassandra.CassandraClient ret = io.vertx.mutiny.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName, options));
    return ret;
  }

  /**
   * @return whether this Cassandra client instance is connected
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query the query to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.cassandra.ResultSet> execute(String query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.execute(query, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query the query to execute
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.mutiny.cassandra.ResultSet executeAndAwait(String query) { 
    return (io.vertx.mutiny.cassandra.ResultSet) execute(query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#execute(String)} but you don't need to compose it with other operations.
   * @param query the query to execute
   * @return the instance of CassandraClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.cassandra.CassandraClient executeAndForget(String query) { 
    execute(query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.cassandra.CassandraRowStream> queryStream(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(rowStreamHandler -> {
        delegate.queryStream(sql, new io.smallrye.mutiny.vertx.DelegatingHandler<>(rowStreamHandler, ar -> ar.map(event -> io.vertx.mutiny.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the CassandraRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.cassandra.CassandraRowStream queryStreamAndAwait(String sql) { 
    return (io.vertx.mutiny.cassandra.CassandraRowStream) queryStream(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(String)} but you don't need to compose it with other operations.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return the instance of CassandraClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.cassandra.CassandraClient queryStreamAndForget(String sql) { 
    queryStream(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes this client.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(closeHandler -> {
        delegate.close(closeHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#close} but you don't need to compose it with other operations.
   * @return the instance of CassandraClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.cassandra.CassandraClient closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query the query to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(String query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executeWithFullFetch(query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query the query to execute
   * @return the List<Row> instance produced by the operation.
   */
  public List<com.datastax.oss.driver.api.core.cql.Row> executeWithFullFetchAndAwait(String query) { 
    return (List<com.datastax.oss.driver.api.core.cql.Row>) executeWithFullFetch(query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(String)} but you don't need to compose it with other operations.
   * @param query the query to execute
   */
  public void executeWithFullFetchAndForget(String query) { 
    executeWithFullFetch(query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statement the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executeWithFullFetch(statement, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(Statement)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statement the statement to execute
   * @return the List<Row> instance produced by the operation.
   */
  public List<com.datastax.oss.driver.api.core.cql.Row> executeWithFullFetchAndAwait(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return (List<com.datastax.oss.driver.api.core.cql.Row>) executeWithFullFetch(statement).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(Statement)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(Statement)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#executeWithFullFetch(Statement)} but you don't need to compose it with other operations.
   * @param statement the statement to execute
   */
  public void executeWithFullFetchAndForget(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    executeWithFullFetch(statement).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statement the statement to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.cassandra.ResultSet> execute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.execute(statement, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(Statement)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statement the statement to execute
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.mutiny.cassandra.ResultSet executeAndAwait(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return (io.vertx.mutiny.cassandra.ResultSet) execute(statement).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(Statement)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#execute(Statement)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#execute(Statement)} but you don't need to compose it with other operations.
   * @param statement the statement to execute
   * @return the instance of CassandraClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.cassandra.CassandraClient executeAndForget(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    execute(statement).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Prepares the provided query string.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query the query to prepare
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(String query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.prepare(query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query the query to prepare
   * @return the PreparedStatement instance produced by the operation.
   */
  public com.datastax.oss.driver.api.core.cql.PreparedStatement prepareAndAwait(String query) { 
    return (com.datastax.oss.driver.api.core.cql.PreparedStatement) prepare(query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(String)} but you don't need to compose it with other operations.
   * @param query the query to prepare
   */
  public void prepareAndForget(String query) { 
    prepare(query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Prepares the provided a .
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statement the statement to prepare
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.prepare(statement, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(SimpleStatement)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statement the statement to prepare
   * @return the PreparedStatement instance produced by the operation.
   */
  public com.datastax.oss.driver.api.core.cql.PreparedStatement prepareAndAwait(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    return (com.datastax.oss.driver.api.core.cql.PreparedStatement) prepare(statement).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(SimpleStatement)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(SimpleStatement)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#prepare(SimpleStatement)} but you don't need to compose it with other operations.
   * @param statement the statement to prepare
   */
  public void prepareAndForget(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    prepare(statement).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param statement the statement to execute.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.cassandra.CassandraRowStream> queryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(rowStreamHandler -> {
        delegate.queryStream(statement, new io.smallrye.mutiny.vertx.DelegatingHandler<>(rowStreamHandler, ar -> ar.map(event -> io.vertx.mutiny.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(Statement)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param statement the statement to execute.
   * @return the CassandraRowStream instance produced by the operation.
   */
  public io.vertx.mutiny.cassandra.CassandraRowStream queryStreamAndAwait(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return (io.vertx.mutiny.cassandra.CassandraRowStream) queryStream(statement).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(Statement)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(Statement)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#queryStream(Statement)} but you don't need to compose it with other operations.
   * @param statement the statement to execute.
   * @return the instance of CassandraClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.cassandra.CassandraClient queryStreamAndForget(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    queryStream(statement).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get  for the session.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<com.datastax.oss.driver.api.core.metadata.Metadata> metadata() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.metadata(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.CassandraClient#metadata}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Metadata instance produced by the operation.
   */
  public com.datastax.oss.driver.api.core.metadata.Metadata metadataAndAwait() { 
    return (com.datastax.oss.driver.api.core.metadata.Metadata) metadata().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.CassandraClient#metadata} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.CassandraClient#metadata}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.CassandraClient#metadata} but you don't need to compose it with other operations.
   */
  public void metadataAndForget() { 
    metadata().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * The default shared client name.
   */
  public static final String DEFAULT_SHARED_CLIENT_NAME = io.vertx.cassandra.CassandraClient.DEFAULT_SHARED_CLIENT_NAME;
  public static  CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
    return arg != null ? new CassandraClient(arg) : null;
  }

}
