package io.vertx.mutiny.cassandra;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import java.util.List;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import com.datastax.oss.driver.api.core.cql.Row;

/**
 * It is like {@link com.datastax.oss.driver.api.core.cql.AsyncResultSet}, but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet {

  public static final io.smallrye.mutiny.vertx.TypeArg<ResultSet> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public ResultSet(Object delegate) {
    this.delegate = (io.vertx.cassandra.ResultSet)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ResultSet() {
    this.delegate = null;
  }

  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public int remaining() { 
    int ret = delegate.remaining();
    return ret;
  }

  /**
   * @return 
   */
  public boolean hasMorePages() { 
    boolean ret = delegate.hasMorePages();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.cassandra.ResultSet> fetchNextPage() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.fetchNextPage(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ResultSet instance produced by the operation.
   */
  public io.vertx.mutiny.cassandra.ResultSet fetchNextPageAndAwait() { 
    return (io.vertx.mutiny.cassandra.ResultSet) fetchNextPage().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage} but you don't need to compose it with other operations.
   */
  public void fetchNextPageAndForget() { 
    fetchNextPage().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.mutiny.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<com.datastax.oss.driver.api.core.cql.Row>> all() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.all(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.cassandra.ResultSet#all}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<Row> instance produced by the operation.
   */
  public List<com.datastax.oss.driver.api.core.cql.Row> allAndAwait() { 
    return (List<com.datastax.oss.driver.api.core.cql.Row>) all().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.cassandra.ResultSet#all} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.cassandra.ResultSet#all}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.cassandra.ResultSet#all} but you don't need to compose it with other operations.
   */
  public void allAndForget() { 
    all().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions getColumnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo getExecutionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.getExecutionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> currentPage() { 
    java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> ret = delegate.currentPage();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.Row one() { 
    com.datastax.oss.driver.api.core.cql.Row ret = delegate.one();
    return ret;
  }

  public static  ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }

}
