package io.vertx.mutiny.config;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.config.ConfigChange;

/**
 * Defines a configuration retriever that read configuration from
 * 
 * and tracks changes periodically.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.config.ConfigRetriever original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.config.ConfigRetriever.class)
public class ConfigRetriever {

  public static final io.smallrye.mutiny.vertx.TypeArg<ConfigRetriever> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ConfigRetriever((io.vertx.config.ConfigRetriever) obj),
    ConfigRetriever::getDelegate
  );

  private final io.vertx.config.ConfigRetriever delegate;
  
  public ConfigRetriever(io.vertx.config.ConfigRetriever delegate) {
    this.delegate = delegate;
  }

  public ConfigRetriever(Object delegate) {
    this.delegate = (io.vertx.config.ConfigRetriever)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ConfigRetriever() {
    this.delegate = null;
  }

  public io.vertx.config.ConfigRetriever getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigRetriever that = (ConfigRetriever) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance
   * @param options the options, must not be <code>null</code>, must contain the list of configured store.
   * @return the created instance.
   */
  public static io.vertx.mutiny.config.ConfigRetriever create(io.vertx.mutiny.core.Vertx vertx, io.vertx.config.ConfigRetrieverOptions options) { 
    io.vertx.mutiny.config.ConfigRetriever ret = io.vertx.mutiny.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vert.x instance
   * @return the created instance.
   */
  public static io.vertx.mutiny.config.ConfigRetriever create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.config.ConfigRetriever ret = io.vertx.mutiny.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> getConfig() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.getConfig(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.config.ConfigRetriever#getConfig}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject getConfigAndAwait() { 
    return (JsonObject) getConfig().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.config.ConfigRetriever#getConfig} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.config.ConfigRetriever#getConfig}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.config.ConfigRetriever#getConfig} but you don't need to compose it with other operations.
   */
  public void getConfigAndForget() { 
    getConfig().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the last configuration
   */
  public JsonObject getCachedConfig() { 
    JsonObject ret = delegate.getCachedConfig();
    return ret;
  }

  /**
   * @param listener the listener
   */
  private void __listen(Handler<io.vertx.config.ConfigChange> listener) { 
    delegate.listen(listener);
  }

  /**
   * @param listener the listener
   */
  public void listen(java.util.function.Consumer<io.vertx.config.ConfigChange> listener) {
    __listen(listener != null ? listener::accept : null);
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return the current config retriever
   */
  @Fluent
  private io.vertx.mutiny.config.ConfigRetriever __setBeforeScanHandler(Handler<Void> handler) { 
    delegate.setBeforeScanHandler(handler);
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return 
   */
  public io.vertx.mutiny.config.ConfigRetriever setBeforeScanHandler(java.lang.Runnable handler) {
    return __setBeforeScanHandler(ignored -> handler.run()
);
  }

  /**
   * @param processor the processor, must not be <code>null</code>. The method must not return <code>null</code>. The returned configuration is used. If the processor does not update the configuration, it must return the input configuration. If the processor throws an exception, the failure is passed to the {@link io.vertx.mutiny.config.ConfigRetriever#getConfig} handler.
   * @return the current config retriever
   */
  @Fluent
  public io.vertx.mutiny.config.ConfigRetriever setConfigurationProcessor(Function<JsonObject, JsonObject> processor) { 
    delegate.setConfigurationProcessor(processor);
    return this;
  }

  /**
   * @return the stream of configurations. It's single stream (unicast) and that delivers the last known config and the successors periodically.
   */
  public io.vertx.mutiny.core.streams.ReadStream<JsonObject> configStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.streams.ReadStream<JsonObject> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.configStream(), TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.mutiny.core.streams.ReadStream<JsonObject> cached_0;
  public static  ConfigRetriever newInstance(io.vertx.config.ConfigRetriever arg) {
    return arg != null ? new ConfigRetriever(arg) : null;
  }

}
