package io.vertx.mutiny.ext.consul;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.core.Future;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import java.util.List;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.CheckList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.EventOptions;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<ConsulClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public ConsulClient(Object delegate) {
    this.delegate = (io.vertx.ext.consul.ConsulClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ConsulClient() {
    this.delegate = null;
  }

  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static io.vertx.mutiny.ext.consul.ConsulClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.ConsulClient ret = io.vertx.mutiny.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.mutiny.ext.consul.ConsulClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.ConsulClient ret = io.vertx.mutiny.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<JsonObject> agentInfo() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.agentInfo(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#agentInfo}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the JsonObject instance produced by the operation.
   */
  public JsonObject agentInfoAndAwait() { 
    return (JsonObject) agentInfo().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#agentInfo} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#agentInfo}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#agentInfo} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient agentInfoAndForget() { 
    agentInfo().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CoordinateList> coordinateNodes() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.coordinateNodes(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodes}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the CoordinateList instance produced by the operation.
   */
  public io.vertx.ext.consul.CoordinateList coordinateNodesAndAwait() { 
    return (io.vertx.ext.consul.CoordinateList) coordinateNodes().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodes} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodes}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodes} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient coordinateNodesAndForget() { 
    coordinateNodes().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodes}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CoordinateList> coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.coordinateNodesWithOptions(options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodesWithOptions(BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the blocking options
   * @return the CoordinateList instance produced by the operation.
   */
  public io.vertx.ext.consul.CoordinateList coordinateNodesWithOptionsAndAwait(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.CoordinateList) coordinateNodesWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodesWithOptions(BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodesWithOptions(BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateNodesWithOptions(BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient coordinateNodesWithOptionsAndForget(io.vertx.ext.consul.BlockingQueryOptions options) { 
    coordinateNodesWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.ext.consul.DcCoordinates>> coordinateDatacenters() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.coordinateDatacenters(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateDatacenters}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<DcCoordinates> instance produced by the operation.
   */
  public List<io.vertx.ext.consul.DcCoordinates> coordinateDatacentersAndAwait() { 
    return (List<io.vertx.ext.consul.DcCoordinates>) coordinateDatacenters().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateDatacenters} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateDatacenters}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#coordinateDatacenters} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient coordinateDatacentersAndForget() { 
    coordinateDatacenters().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param keyPrefix the prefix
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> getKeys(String keyPrefix) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getKeys(keyPrefix, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeys(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param keyPrefix the prefix
   * @return the List<String> instance produced by the operation.
   */
  public List<String> getKeysAndAwait(String keyPrefix) { 
    return (List<String>) getKeys(keyPrefix).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeys(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeys(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeys(String)} but you don't need to compose it with other operations.
   * @param keyPrefix the prefix
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getKeysAndForget(String keyPrefix) { 
    getKeys(keyPrefix).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> getKeysWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeysWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the List<String> instance produced by the operation.
   */
  public List<String> getKeysWithOptionsAndAwait(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (List<String>) getKeysWithOptions(keyPrefix, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeysWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeysWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getKeysWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getKeysWithOptionsAndForget(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    getKeysWithOptions(keyPrefix, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param key the key
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.KeyValue> getValue(String key) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getValue(key, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValue(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param key the key
   * @return the KeyValue instance produced by the operation.
   */
  public io.vertx.ext.consul.KeyValue getValueAndAwait(String key) { 
    return (io.vertx.ext.consul.KeyValue) getValue(key).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValue(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValue(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getValue(String)} but you don't need to compose it with other operations.
   * @param key the key
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getValueAndForget(String key) { 
    getValue(key).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#getValue}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param key the key
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.KeyValue> getValueWithOptions(String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getValueWithOptions(key, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValueWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param key the key
   * @param options the blocking options
   * @return the KeyValue instance produced by the operation.
   */
  public io.vertx.ext.consul.KeyValue getValueWithOptionsAndAwait(String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.KeyValue) getValueWithOptions(key, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValueWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValueWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getValueWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param key the key
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getValueWithOptionsAndForget(String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    getValueWithOptions(key, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param key the key
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deleteValue(String key) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deleteValue(key, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValue(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param key the key
   * @return the Void instance produced by the operation.
   */
  public Void deleteValueAndAwait(String key) { 
    return (Void) deleteValue(key).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValue(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValue(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValue(String)} but you don't need to compose it with other operations.
   * @param key the key
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deleteValueAndForget(String key) { 
    deleteValue(key).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param keyPrefix the prefix
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.KeyValueList> getValues(String keyPrefix) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getValues(keyPrefix, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValues(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param keyPrefix the prefix
   * @return the KeyValueList instance produced by the operation.
   */
  public io.vertx.ext.consul.KeyValueList getValuesAndAwait(String keyPrefix) { 
    return (io.vertx.ext.consul.KeyValueList) getValues(keyPrefix).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValues(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValues(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getValues(String)} but you don't need to compose it with other operations.
   * @param keyPrefix the prefix
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getValuesAndForget(String keyPrefix) { 
    getValues(keyPrefix).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#getValues}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.KeyValueList> getValuesWithOptions(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValuesWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the KeyValueList instance produced by the operation.
   */
  public io.vertx.ext.consul.KeyValueList getValuesWithOptionsAndAwait(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.KeyValueList) getValuesWithOptions(keyPrefix, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValuesWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getValuesWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getValuesWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getValuesWithOptionsAndForget(String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    getValuesWithOptions(keyPrefix, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param keyPrefix the prefix
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deleteValues(String keyPrefix) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deleteValues(keyPrefix, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValues(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param keyPrefix the prefix
   * @return the Void instance produced by the operation.
   */
  public Void deleteValuesAndAwait(String keyPrefix) { 
    return (Void) deleteValues(keyPrefix).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValues(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValues(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deleteValues(String)} but you don't need to compose it with other operations.
   * @param keyPrefix the prefix
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deleteValuesAndForget(String keyPrefix) { 
    deleteValues(keyPrefix).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Adds specified key/value pair
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param key the key
   * @param value the value
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> putValue(String key, String value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.putValue(key, value, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValue(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param key the key
   * @param value the value
   * @return the Boolean instance produced by the operation.
   */
  public Boolean putValueAndAwait(String key, String value) { 
    return (Boolean) putValue(key, value).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValue(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValue(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#putValue(String,String)} but you don't need to compose it with other operations.
   * @param key the key
   * @param value the value
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient putValueAndForget(String key, String value) { 
    putValue(key, value).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> putValueWithOptions(String key, String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.putValueWithOptions(key, value, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValueWithOptions(String,String,KeyValueOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return the Boolean instance produced by the operation.
   */
  public Boolean putValueWithOptionsAndAwait(String key, String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return (Boolean) putValueWithOptions(key, value, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValueWithOptions(String,String,KeyValueOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#putValueWithOptions(String,String,KeyValueOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#putValueWithOptions(String,String,KeyValueOptions)} but you don't need to compose it with other operations.
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient putValueWithOptionsAndForget(String key, String value, io.vertx.ext.consul.KeyValueOptions options) { 
    putValueWithOptions(key, value, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param request transaction request
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.TxnResponse> transaction(io.vertx.ext.consul.TxnRequest request) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.transaction(request, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#transaction(TxnRequest)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param request transaction request
   * @return the TxnResponse instance produced by the operation.
   */
  public io.vertx.ext.consul.TxnResponse transactionAndAwait(io.vertx.ext.consul.TxnRequest request) { 
    return (io.vertx.ext.consul.TxnResponse) transaction(request).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#transaction(TxnRequest)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#transaction(TxnRequest)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#transaction(TxnRequest)} but you don't need to compose it with other operations.
   * @param request transaction request
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient transactionAndForget(io.vertx.ext.consul.TxnRequest request) { 
    transaction(request).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Create new Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param token properties of the token
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createAclToken(io.vertx.ext.consul.AclToken token) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(idHandler -> {
        delegate.createAclToken(token, idHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createAclToken(AclToken)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param token properties of the token
   * @return the String instance produced by the operation.
   */
  public String createAclTokenAndAwait(io.vertx.ext.consul.AclToken token) { 
    return (String) createAclToken(token).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createAclToken(AclToken)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#createAclToken(AclToken)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#createAclToken(AclToken)} but you don't need to compose it with other operations.
   * @param token properties of the token
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient createAclTokenAndForget(io.vertx.ext.consul.AclToken token) { 
    createAclToken(token).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Update Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param token properties of the token to be updated
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> updateAclToken(io.vertx.ext.consul.AclToken token) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(idHandler -> {
        delegate.updateAclToken(token, idHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateAclToken(AclToken)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param token properties of the token to be updated
   * @return the String instance produced by the operation.
   */
  public String updateAclTokenAndAwait(io.vertx.ext.consul.AclToken token) { 
    return (String) updateAclToken(token).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateAclToken(AclToken)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateAclToken(AclToken)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#updateAclToken(AclToken)} but you don't need to compose it with other operations.
   * @param token properties of the token to be updated
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient updateAclTokenAndForget(io.vertx.ext.consul.AclToken token) { 
    updateAclToken(token).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Clone Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of token to be cloned
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> cloneAclToken(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(idHandler -> {
        delegate.cloneAclToken(id, idHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#cloneAclToken(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of token to be cloned
   * @return the String instance produced by the operation.
   */
  public String cloneAclTokenAndAwait(String id) { 
    return (String) cloneAclToken(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#cloneAclToken(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#cloneAclToken(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#cloneAclToken(String)} but you don't need to compose it with other operations.
   * @param id the ID of token to be cloned
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient cloneAclTokenAndForget(String id) { 
    cloneAclToken(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get list of Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.ext.consul.AclToken>> listAclTokens() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listAclTokens(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listAclTokens}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<AclToken> instance produced by the operation.
   */
  public List<io.vertx.ext.consul.AclToken> listAclTokensAndAwait() { 
    return (List<io.vertx.ext.consul.AclToken>) listAclTokens().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listAclTokens} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listAclTokens}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listAclTokens} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listAclTokensAndForget() { 
    listAclTokens().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get info of Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of token
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.AclToken> infoAclToken(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(tokenHandler -> {
        delegate.infoAclToken(id, tokenHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoAclToken(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of token
   * @return the AclToken instance produced by the operation.
   */
  public io.vertx.ext.consul.AclToken infoAclTokenAndAwait(String id) { 
    return (io.vertx.ext.consul.AclToken) infoAclToken(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoAclToken(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoAclToken(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#infoAclToken(String)} but you don't need to compose it with other operations.
   * @param id the ID of token
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient infoAclTokenAndForget(String id) { 
    infoAclToken(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Destroy Acl token
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of token
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> destroyAclToken(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.destroyAclToken(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroyAclToken(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of token
   * @return the Void instance produced by the operation.
   */
  public Void destroyAclTokenAndAwait(String id) { 
    return (Void) destroyAclToken(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroyAclToken(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroyAclToken(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#destroyAclToken(String)} but you don't need to compose it with other operations.
   * @param id the ID of token
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient destroyAclTokenAndForget(String id) { 
    destroyAclToken(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Fires a new user event
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name name of event
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.Event> fireEvent(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.fireEvent(name, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEvent(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name name of event
   * @return the Event instance produced by the operation.
   */
  public io.vertx.ext.consul.Event fireEventAndAwait(String name) { 
    return (io.vertx.ext.consul.Event) fireEvent(name).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEvent(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEvent(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEvent(String)} but you don't need to compose it with other operations.
   * @param name name of event
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient fireEventAndForget(String name) { 
    fireEvent(name).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Fires a new user event
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param name name of event
   * @param options options used to create event
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.Event> fireEventWithOptions(String name, io.vertx.ext.consul.EventOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.fireEventWithOptions(name, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEventWithOptions(String,EventOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param name name of event
   * @param options options used to create event
   * @return the Event instance produced by the operation.
   */
  public io.vertx.ext.consul.Event fireEventWithOptionsAndAwait(String name, io.vertx.ext.consul.EventOptions options) { 
    return (io.vertx.ext.consul.Event) fireEventWithOptions(name, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEventWithOptions(String,EventOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEventWithOptions(String,EventOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#fireEventWithOptions(String,EventOptions)} but you don't need to compose it with other operations.
   * @param name name of event
   * @param options options used to create event
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient fireEventWithOptionsAndForget(String name, io.vertx.ext.consul.EventOptions options) { 
    fireEventWithOptions(name, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the most recent events known by the agent
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.EventList> listEvents() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listEvents(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEvents}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the EventList instance produced by the operation.
   */
  public io.vertx.ext.consul.EventList listEventsAndAwait() { 
    return (io.vertx.ext.consul.EventList) listEvents().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEvents} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEvents}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listEvents} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listEventsAndForget() { 
    listEvents().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.EventList> listEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listEventsWithOptions(options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEventsWithOptions(EventListOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the blocking options
   * @return the EventList instance produced by the operation.
   */
  public io.vertx.ext.consul.EventList listEventsWithOptionsAndAwait(io.vertx.ext.consul.EventListOptions options) { 
    return (io.vertx.ext.consul.EventList) listEventsWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEventsWithOptions(EventListOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listEventsWithOptions(EventListOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listEventsWithOptions(EventListOptions)} but you don't need to compose it with other operations.
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listEventsWithOptionsAndForget(io.vertx.ext.consul.EventListOptions options) { 
    listEventsWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param serviceOptions the options of new service
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> registerService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.registerService(serviceOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerService(ServiceOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param serviceOptions the options of new service
   * @return the Void instance produced by the operation.
   */
  public Void registerServiceAndAwait(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return (Void) registerService(serviceOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerService(ServiceOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerService(ServiceOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#registerService(ServiceOptions)} but you don't need to compose it with other operations.
   * @param serviceOptions the options of new service
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient registerServiceAndForget(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    registerService(serviceOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Places a given service into "maintenance mode"
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param maintenanceOptions the maintenance options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.maintenanceService(maintenanceOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#maintenanceService(MaintenanceOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param maintenanceOptions the maintenance options
   * @return the Void instance produced by the operation.
   */
  public Void maintenanceServiceAndAwait(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return (Void) maintenanceService(maintenanceOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#maintenanceService(MaintenanceOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#maintenanceService(MaintenanceOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#maintenanceService(MaintenanceOptions)} but you don't need to compose it with other operations.
   * @param maintenanceOptions the maintenance options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient maintenanceServiceAndForget(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    maintenanceService(maintenanceOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of service
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deregisterService(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deregisterService(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterService(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of service
   * @return the Void instance produced by the operation.
   */
  public Void deregisterServiceAndAwait(String id) { 
    return (Void) deregisterService(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterService(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterService(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterService(String)} but you don't need to compose it with other operations.
   * @param id the ID of service
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deregisterServiceAndForget(String id) { 
    deregisterService(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service name of service
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogServiceNodes(String service) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogServiceNodes(service, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodes(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service name of service
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogServiceNodesAndAwait(String service) { 
    return (io.vertx.ext.consul.ServiceList) catalogServiceNodes(service).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodes(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodes(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodes(String)} but you don't need to compose it with other operations.
   * @param service name of service
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogServiceNodesAndForget(String service) { 
    catalogServiceNodes(service).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service name of service
   * @param options options used to request services
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogServiceNodesWithOptions(String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodesWithOptions(String,ServiceQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service name of service
   * @param options options used to request services
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogServiceNodesWithOptionsAndAwait(String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return (io.vertx.ext.consul.ServiceList) catalogServiceNodesWithOptions(service, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodesWithOptions(String,ServiceQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodesWithOptions(String,ServiceQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodesWithOptions(String,ServiceQueryOptions)} but you don't need to compose it with other operations.
   * @param service name of service
   * @param options options used to request services
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogServiceNodesWithOptionsAndForget(String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    catalogServiceNodesWithOptions(service, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> catalogDatacenters() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogDatacenters(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogDatacenters}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<String> instance produced by the operation.
   */
  public List<String> catalogDatacentersAndAwait() { 
    return (List<String>) catalogDatacenters().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogDatacenters} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogDatacenters}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogDatacenters} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogDatacentersAndForget() { 
    catalogDatacenters().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.NodeList> catalogNodes() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogNodes(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodes}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the NodeList instance produced by the operation.
   */
  public io.vertx.ext.consul.NodeList catalogNodesAndAwait() { 
    return (io.vertx.ext.consul.NodeList) catalogNodes().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodes} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodes}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodes} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogNodesAndForget() { 
    catalogNodes().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options options used to request nodes
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.NodeList> catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogNodesWithOptions(options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodesWithOptions(NodeQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options options used to request nodes
   * @return the NodeList instance produced by the operation.
   */
  public io.vertx.ext.consul.NodeList catalogNodesWithOptionsAndAwait(io.vertx.ext.consul.NodeQueryOptions options) { 
    return (io.vertx.ext.consul.NodeList) catalogNodesWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodesWithOptions(NodeQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodesWithOptions(NodeQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodesWithOptions(NodeQueryOptions)} but you don't need to compose it with other operations.
   * @param options options used to request nodes
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogNodesWithOptionsAndForget(io.vertx.ext.consul.NodeQueryOptions options) { 
    catalogNodesWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service the service name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CheckList> healthChecks(String service) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthChecks(service, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecks(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service the service name
   * @return the CheckList instance produced by the operation.
   */
  public io.vertx.ext.consul.CheckList healthChecksAndAwait(String service) { 
    return (io.vertx.ext.consul.CheckList) healthChecks(service).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecks(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecks(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecks(String)} but you don't need to compose it with other operations.
   * @param service the service name
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthChecksAndForget(String service) { 
    healthChecks(service).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service the service name
   * @param options options used to request checks
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CheckList> healthChecksWithOptions(String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthChecksWithOptions(service, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecksWithOptions(String,CheckQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service the service name
   * @param options options used to request checks
   * @return the CheckList instance produced by the operation.
   */
  public io.vertx.ext.consul.CheckList healthChecksWithOptionsAndAwait(String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return (io.vertx.ext.consul.CheckList) healthChecksWithOptions(service, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecksWithOptions(String,CheckQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecksWithOptions(String,CheckQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthChecksWithOptions(String,CheckQueryOptions)} but you don't need to compose it with other operations.
   * @param service the service name
   * @param options options used to request checks
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthChecksWithOptionsAndForget(String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    healthChecksWithOptions(service, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param healthState the health state
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CheckList> healthState(io.vertx.ext.consul.HealthState healthState) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthState(healthState, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthState(HealthState)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param healthState the health state
   * @return the CheckList instance produced by the operation.
   */
  public io.vertx.ext.consul.CheckList healthStateAndAwait(io.vertx.ext.consul.HealthState healthState) { 
    return (io.vertx.ext.consul.CheckList) healthState(healthState).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthState(HealthState)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthState(HealthState)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthState(HealthState)} but you don't need to compose it with other operations.
   * @param healthState the health state
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthStateAndForget(io.vertx.ext.consul.HealthState healthState) { 
    healthState(healthState).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param healthState the health state
   * @param options options used to request checks
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.CheckList> healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthStateWithOptions(healthState, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthStateWithOptions(HealthState,CheckQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param healthState the health state
   * @param options options used to request checks
   * @return the CheckList instance produced by the operation.
   */
  public io.vertx.ext.consul.CheckList healthStateWithOptionsAndAwait(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    return (io.vertx.ext.consul.CheckList) healthStateWithOptions(healthState, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthStateWithOptions(HealthState,CheckQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthStateWithOptions(HealthState,CheckQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthStateWithOptions(HealthState,CheckQueryOptions)} but you don't need to compose it with other operations.
   * @param healthState the health state
   * @param options options used to request checks
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthStateWithOptionsAndForget(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    healthStateWithOptions(healthState, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceEntryList> healthServiceNodes(String service, boolean passing) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthServiceNodes(service, passing, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodes(String,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return the ServiceEntryList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceEntryList healthServiceNodesAndAwait(String service, boolean passing) { 
    return (io.vertx.ext.consul.ServiceEntryList) healthServiceNodes(service, passing).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodes(String,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodes(String,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodes(String,boolean)} but you don't need to compose it with other operations.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthServiceNodesAndForget(String service, boolean passing) { 
    healthServiceNodes(service, passing).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceEntryList> healthServiceNodesWithOptions(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodesWithOptions(String,boolean,ServiceQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return the ServiceEntryList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceEntryList healthServiceNodesWithOptionsAndAwait(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return (io.vertx.ext.consul.ServiceEntryList) healthServiceNodesWithOptions(service, passing, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodesWithOptions(String,boolean,ServiceQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodesWithOptions(String,boolean,ServiceQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#healthServiceNodesWithOptions(String,boolean,ServiceQueryOptions)} but you don't need to compose it with other operations.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient healthServiceNodesWithOptionsAndForget(String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    healthServiceNodesWithOptions(service, passing, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogServices() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogServices(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServices}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogServicesAndAwait() { 
    return (io.vertx.ext.consul.ServiceList) catalogServices().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServices} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServices}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServices} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogServicesAndForget() { 
    catalogServices().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServices}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogServicesWithOptions(options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServicesWithOptions(BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the blocking options
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogServicesWithOptionsAndAwait(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.ServiceList) catalogServicesWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServicesWithOptions(BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServicesWithOptions(BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogServicesWithOptions(BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogServicesWithOptionsAndForget(io.vertx.ext.consul.BlockingQueryOptions options) { 
    catalogServicesWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the node's registered services
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param node node name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogNodeServices(String node) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogNodeServices(node, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServices(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param node node name
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogNodeServicesAndAwait(String node) { 
    return (io.vertx.ext.consul.ServiceList) catalogNodeServices(node).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServices(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServices(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServices(String)} but you don't need to compose it with other operations.
   * @param node node name
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogNodeServicesAndForget(String node) { 
    catalogNodeServices(node).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServices}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param node node name
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.ServiceList> catalogNodeServicesWithOptions(String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServicesWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param node node name
   * @param options the blocking options
   * @return the ServiceList instance produced by the operation.
   */
  public io.vertx.ext.consul.ServiceList catalogNodeServicesWithOptionsAndAwait(String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.ServiceList) catalogNodeServicesWithOptions(node, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServicesWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServicesWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#catalogNodeServicesWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param node node name
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient catalogNodeServicesWithOptionsAndForget(String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    catalogNodeServicesWithOptions(node, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns list of services registered with the local agent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.ext.consul.Service>> localServices() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.localServices(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#localServices}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<Service> instance produced by the operation.
   */
  public List<io.vertx.ext.consul.Service> localServicesAndAwait() { 
    return (List<io.vertx.ext.consul.Service>) localServices().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#localServices} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#localServices}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#localServices} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient localServicesAndForget() { 
    localServices().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.ext.consul.Check>> localChecks() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.localChecks(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#localChecks}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<Check> instance produced by the operation.
   */
  public List<io.vertx.ext.consul.Check> localChecksAndAwait() { 
    return (List<io.vertx.ext.consul.Check>) localChecks().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#localChecks} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#localChecks}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#localChecks} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient localChecksAndForget() { 
    localChecks().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkOptions options used to register new check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> registerCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.registerCheck(checkOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCheck(CheckOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkOptions options used to register new check
   * @return the Void instance produced by the operation.
   */
  public Void registerCheckAndAwait(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return (Void) registerCheck(checkOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCheck(CheckOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCheck(CheckOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCheck(CheckOptions)} but you don't need to compose it with other operations.
   * @param checkOptions options used to register new check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient registerCheckAndForget(io.vertx.ext.consul.CheckOptions checkOptions) { 
    registerCheck(checkOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deregisterCheck(String checkId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deregisterCheck(checkId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCheck(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @return the Void instance produced by the operation.
   */
  public Void deregisterCheckAndAwait(String checkId) { 
    return (Void) deregisterCheck(checkId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCheck(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCheck(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCheck(String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deregisterCheckAndForget(String checkId) { 
    deregisterCheck(checkId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> passCheck(String checkId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.passCheck(checkId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheck(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @return the Void instance produced by the operation.
   */
  public Void passCheckAndAwait(String checkId) { 
    return (Void) passCheck(checkId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheck(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheck(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheck(String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient passCheckAndForget(String checkId) { 
    passCheck(checkId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> passCheckWithNote(String checkId, String note) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.passCheckWithNote(checkId, note, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheckWithNote(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the Void instance produced by the operation.
   */
  public Void passCheckWithNoteAndAwait(String checkId, String note) { 
    return (Void) passCheckWithNote(checkId, note).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheckWithNote(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheckWithNote(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#passCheckWithNote(String,String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient passCheckWithNoteAndForget(String checkId, String note) { 
    passCheckWithNote(checkId, note).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> warnCheck(String checkId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.warnCheck(checkId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheck(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @return the Void instance produced by the operation.
   */
  public Void warnCheckAndAwait(String checkId) { 
    return (Void) warnCheck(checkId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheck(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheck(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheck(String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient warnCheckAndForget(String checkId) { 
    warnCheck(checkId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> warnCheckWithNote(String checkId, String note) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.warnCheckWithNote(checkId, note, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheckWithNote(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the Void instance produced by the operation.
   */
  public Void warnCheckWithNoteAndAwait(String checkId, String note) { 
    return (Void) warnCheckWithNote(checkId, note).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheckWithNote(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheckWithNote(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#warnCheckWithNote(String,String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient warnCheckWithNoteAndForget(String checkId, String note) { 
    warnCheckWithNote(checkId, note).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> failCheck(String checkId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.failCheck(checkId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheck(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @return the Void instance produced by the operation.
   */
  public Void failCheckAndAwait(String checkId) { 
    return (Void) failCheck(checkId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheck(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheck(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheck(String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient failCheckAndForget(String checkId) { 
    failCheck(checkId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> failCheckWithNote(String checkId, String note) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.failCheckWithNote(checkId, note, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheckWithNote(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the Void instance produced by the operation.
   */
  public Void failCheckWithNoteAndAwait(String checkId, String note) { 
    return (Void) failCheckWithNote(checkId, note).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheckWithNote(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheckWithNote(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#failCheckWithNote(String,String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient failCheckWithNoteAndForget(String checkId, String note) { 
    failCheckWithNote(checkId, note).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @param status new status of check
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> updateCheck(String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCheck(checkId, status, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheck(String,CheckStatus)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @param status new status of check
   * @return the Void instance produced by the operation.
   */
  public Void updateCheckAndAwait(String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return (Void) updateCheck(checkId, status).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheck(String,CheckStatus)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheck(String,CheckStatus)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheck(String,CheckStatus)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @param status new status of check
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient updateCheckAndForget(String checkId, io.vertx.ext.consul.CheckStatus status) { 
    updateCheck(checkId, status).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> updateCheckWithNote(String checkId, io.vertx.ext.consul.CheckStatus status, String note) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheckWithNote(String,CheckStatus,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the Void instance produced by the operation.
   */
  public Void updateCheckWithNoteAndAwait(String checkId, io.vertx.ext.consul.CheckStatus status, String note) { 
    return (Void) updateCheckWithNote(checkId, status, note).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheckWithNote(String,CheckStatus,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheckWithNote(String,CheckStatus,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#updateCheckWithNote(String,CheckStatus,String)} but you don't need to compose it with other operations.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient updateCheckWithNoteAndForget(String checkId, io.vertx.ext.consul.CheckStatus status, String note) { 
    updateCheckWithNote(checkId, status, note).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> leaderStatus() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.leaderStatus(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#leaderStatus}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the String instance produced by the operation.
   */
  public String leaderStatusAndAwait() { 
    return (String) leaderStatus().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#leaderStatus} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#leaderStatus}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#leaderStatus} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient leaderStatusAndForget() { 
    leaderStatus().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<String>> peersStatus() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.peersStatus(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#peersStatus}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<String> instance produced by the operation.
   */
  public List<String> peersStatusAndAwait() { 
    return (List<String>) peersStatus().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#peersStatus} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#peersStatus}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#peersStatus} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient peersStatusAndForget() { 
    peersStatus().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Initialize a new session
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createSession() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(idHandler -> {
        delegate.createSession(idHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSession}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the String instance produced by the operation.
   */
  public String createSessionAndAwait() { 
    return (String) createSession().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSession} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSession}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#createSession} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient createSessionAndForget() { 
    createSession().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Initialize a new session
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options options used to create session
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(idHandler -> {
        delegate.createSessionWithOptions(options, idHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSessionWithOptions(SessionOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options options used to create session
   * @return the String instance produced by the operation.
   */
  public String createSessionWithOptionsAndAwait(io.vertx.ext.consul.SessionOptions options) { 
    return (String) createSessionWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSessionWithOptions(SessionOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#createSessionWithOptions(SessionOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#createSessionWithOptions(SessionOptions)} but you don't need to compose it with other operations.
   * @param options options used to create session
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient createSessionWithOptionsAndForget(io.vertx.ext.consul.SessionOptions options) { 
    createSessionWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the requested session information
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of requested session
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.Session> infoSession(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.infoSession(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSession(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of requested session
   * @return the Session instance produced by the operation.
   */
  public io.vertx.ext.consul.Session infoSessionAndAwait(String id) { 
    return (io.vertx.ext.consul.Session) infoSession(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSession(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSession(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSession(String)} but you don't need to compose it with other operations.
   * @param id the ID of requested session
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient infoSessionAndForget(String id) { 
    infoSession(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSession}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of requested session
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.Session> infoSessionWithOptions(String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.infoSessionWithOptions(id, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSessionWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of requested session
   * @param options the blocking options
   * @return the Session instance produced by the operation.
   */
  public io.vertx.ext.consul.Session infoSessionWithOptionsAndAwait(String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.Session) infoSessionWithOptions(id, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSessionWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSessionWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#infoSessionWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param id the ID of requested session
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient infoSessionWithOptionsAndForget(String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    infoSessionWithOptions(id, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of session that should be renewed
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.Session> renewSession(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.renewSession(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#renewSession(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of session that should be renewed
   * @return the Session instance produced by the operation.
   */
  public io.vertx.ext.consul.Session renewSessionAndAwait(String id) { 
    return (io.vertx.ext.consul.Session) renewSession(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#renewSession(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#renewSession(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#renewSession(String)} but you don't need to compose it with other operations.
   * @param id the ID of session that should be renewed
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient renewSessionAndForget(String id) { 
    renewSession(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the active sessions
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.SessionList> listSessions() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listSessions(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessions}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the SessionList instance produced by the operation.
   */
  public io.vertx.ext.consul.SessionList listSessionsAndAwait() { 
    return (io.vertx.ext.consul.SessionList) listSessions().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessions} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessions}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessions} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listSessionsAndForget() { 
    listSessions().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessions}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.SessionList> listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listSessionsWithOptions(options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessionsWithOptions(BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the blocking options
   * @return the SessionList instance produced by the operation.
   */
  public io.vertx.ext.consul.SessionList listSessionsWithOptionsAndAwait(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.SessionList) listSessionsWithOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessionsWithOptions(BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessionsWithOptions(BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listSessionsWithOptions(BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listSessionsWithOptionsAndForget(io.vertx.ext.consul.BlockingQueryOptions options) { 
    listSessionsWithOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param nodeId the ID of node
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.SessionList> listNodeSessions(String nodeId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listNodeSessions(nodeId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessions(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param nodeId the ID of node
   * @return the SessionList instance produced by the operation.
   */
  public io.vertx.ext.consul.SessionList listNodeSessionsAndAwait(String nodeId) { 
    return (io.vertx.ext.consul.SessionList) listNodeSessions(nodeId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessions(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessions(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessions(String)} but you don't need to compose it with other operations.
   * @param nodeId the ID of node
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listNodeSessionsAndForget(String nodeId) { 
    listNodeSessions(nodeId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessions}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.SessionList> listNodeSessionsWithOptions(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessionsWithOptions(String,BlockingQueryOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return the SessionList instance produced by the operation.
   */
  public io.vertx.ext.consul.SessionList listNodeSessionsWithOptionsAndAwait(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return (io.vertx.ext.consul.SessionList) listNodeSessionsWithOptions(nodeId, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessionsWithOptions(String,BlockingQueryOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessionsWithOptions(String,BlockingQueryOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#listNodeSessionsWithOptions(String,BlockingQueryOptions)} but you don't need to compose it with other operations.
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient listNodeSessionsWithOptionsAndForget(String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    listNodeSessionsWithOptions(nodeId, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Destroys the given session
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the ID of session
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> destroySession(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.destroySession(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroySession(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the ID of session
   * @return the Void instance produced by the operation.
   */
  public Void destroySessionAndAwait(String id) { 
    return (Void) destroySession(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroySession(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#destroySession(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#destroySession(String)} but you don't need to compose it with other operations.
   * @param id the ID of session
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient destroySessionAndForget(String id) { 
    destroySession(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param definition definition of the prepare query
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createPreparedQuery(definition, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createPreparedQuery(PreparedQueryDefinition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param definition definition of the prepare query
   * @return the String instance produced by the operation.
   */
  public String createPreparedQueryAndAwait(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return (String) createPreparedQuery(definition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#createPreparedQuery(PreparedQueryDefinition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#createPreparedQuery(PreparedQueryDefinition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#createPreparedQuery(PreparedQueryDefinition)} but you don't need to compose it with other operations.
   * @param definition definition of the prepare query
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient createPreparedQueryAndForget(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    createPreparedQuery(definition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns an existing prepared query
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the id of the query to read
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.PreparedQueryDefinition> getPreparedQuery(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getPreparedQuery(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getPreparedQuery(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the id of the query to read
   * @return the PreparedQueryDefinition instance produced by the operation.
   */
  public io.vertx.ext.consul.PreparedQueryDefinition getPreparedQueryAndAwait(String id) { 
    return (io.vertx.ext.consul.PreparedQueryDefinition) getPreparedQuery(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getPreparedQuery(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getPreparedQuery(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getPreparedQuery(String)} but you don't need to compose it with other operations.
   * @param id the id of the query to read
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getPreparedQueryAndForget(String id) { 
    getPreparedQuery(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Returns a list of all prepared queries.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.ext.consul.PreparedQueryDefinition>> getAllPreparedQueries() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.getAllPreparedQueries(resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getAllPreparedQueries}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<PreparedQueryDefinition> instance produced by the operation.
   */
  public List<io.vertx.ext.consul.PreparedQueryDefinition> getAllPreparedQueriesAndAwait() { 
    return (List<io.vertx.ext.consul.PreparedQueryDefinition>) getAllPreparedQueries().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#getAllPreparedQueries} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#getAllPreparedQueries}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#getAllPreparedQueries} but you don't need to compose it with other operations.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient getAllPreparedQueriesAndForget() { 
    getAllPreparedQueries().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param definition definition of the prepare query
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.updatePreparedQuery(definition, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updatePreparedQuery(PreparedQueryDefinition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param definition definition of the prepare query
   * @return the Void instance produced by the operation.
   */
  public Void updatePreparedQueryAndAwait(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return (Void) updatePreparedQuery(definition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#updatePreparedQuery(PreparedQueryDefinition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#updatePreparedQuery(PreparedQueryDefinition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#updatePreparedQuery(PreparedQueryDefinition)} but you don't need to compose it with other operations.
   * @param definition definition of the prepare query
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient updatePreparedQueryAndForget(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    updatePreparedQuery(definition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Deletes an existing prepared query
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param id the id of the query to delete
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deletePreparedQuery(String id) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deletePreparedQuery(id, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deletePreparedQuery(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param id the id of the query to delete
   * @return the Void instance produced by the operation.
   */
  public Void deletePreparedQueryAndAwait(String id) { 
    return (Void) deletePreparedQuery(id).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deletePreparedQuery(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deletePreparedQuery(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deletePreparedQuery(String)} but you don't need to compose it with other operations.
   * @param id the id of the query to delete
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deletePreparedQueryAndForget(String id) { 
    deletePreparedQuery(id).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.PreparedQueryExecuteResponse> executePreparedQuery(String query) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executePreparedQuery(query, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQuery(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return the PreparedQueryExecuteResponse instance produced by the operation.
   */
  public io.vertx.ext.consul.PreparedQueryExecuteResponse executePreparedQueryAndAwait(String query) { 
    return (io.vertx.ext.consul.PreparedQueryExecuteResponse) executePreparedQuery(query).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQuery(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQuery(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQuery(String)} but you don't need to compose it with other operations.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient executePreparedQueryAndForget(String query) { 
    executePreparedQuery(query).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.consul.PreparedQueryExecuteResponse> executePreparedQueryWithOptions(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQueryWithOptions(String,PreparedQueryExecuteOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return the PreparedQueryExecuteResponse instance produced by the operation.
   */
  public io.vertx.ext.consul.PreparedQueryExecuteResponse executePreparedQueryWithOptionsAndAwait(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return (io.vertx.ext.consul.PreparedQueryExecuteResponse) executePreparedQueryWithOptions(query, options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQueryWithOptions(String,PreparedQueryExecuteOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQueryWithOptions(String,PreparedQueryExecuteOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#executePreparedQueryWithOptions(String,PreparedQueryExecuteOptions)} but you don't need to compose it with other operations.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient executePreparedQueryWithOptionsAndForget(String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    executePreparedQueryWithOptions(query, options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Register node with external service
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> registerCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.registerCatalogService(nodeOptions, serviceOptions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCatalogService(Node,ServiceOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return the Void instance produced by the operation.
   */
  public Void registerCatalogServiceAndAwait(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return (Void) registerCatalogService(nodeOptions, serviceOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCatalogService(Node,ServiceOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCatalogService(Node,ServiceOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#registerCatalogService(Node,ServiceOptions)} but you don't need to compose it with other operations.
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient registerCatalogServiceAndForget(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    registerCatalogService(nodeOptions, serviceOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> deregisterCatalogService(String nodeId, String serviceId) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.deregisterCatalogService(nodeId, serviceId, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCatalogService(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return the Void instance produced by the operation.
   */
  public Void deregisterCatalogServiceAndAwait(String nodeId, String serviceId) { 
    return (Void) deregisterCatalogService(nodeId, serviceId).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCatalogService(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCatalogService(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.consul.ConsulClient#deregisterCatalogService(String,String)} but you don't need to compose it with other operations.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return the instance of ConsulClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.ConsulClient deregisterCatalogServiceAndForget(String nodeId, String serviceId) { 
    deregisterCatalogService(nodeId, serviceId).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }

}
