package io.vertx.mutiny.ext.consul;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.NodeList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.EventList;

/**
 * Watches are a way of specifying a view of data (e.g. list of nodes, KV pairs, health checks)
 * which is monitored for updates. When an update is detected, an <code>Handler</code> with <code>WatchResult</code> is invoked.
 * All errors, except <code>java.util.concurrent.TimeoutException</code>, will be handled, with resubscribing with a progressive delay.
 * All timeout errors will be ignored, with resubscribing without any delay.
 * As an example, you could watch the status of health checks and notify when a check is critical.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.Watch original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.consul.Watch.class)
public class Watch<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Watch> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Watch((io.vertx.ext.consul.Watch) obj),
    Watch::getDelegate
  );

  private final io.vertx.ext.consul.Watch<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Watch(io.vertx.ext.consul.Watch delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Watch(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.consul.Watch)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public Watch(io.vertx.ext.consul.Watch delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Watch() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.ext.consul.Watch getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Watch that = (Watch) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param key the key
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValue> key(String key, io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValue> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.key(key, vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param key the key
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValue> key(String key, io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValue> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.key(key, vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param keyPrefix the key
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValueList> keyPrefix(String keyPrefix, io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValueList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.keyPrefix(keyPrefix, vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param keyPrefix the key
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValueList> keyPrefix(String keyPrefix, io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.KeyValueList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.keyPrefix(keyPrefix, vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceList> services(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.services(vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceList> services(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.services(vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param service the service name
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceEntryList> service(String service, io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceEntryList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.service(service, vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param service the service name
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceEntryList> service(String service, io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.ServiceEntryList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.service(service, vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param event the event name
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.EventList> events(String event, io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.EventList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.events(event, vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param event the event name
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.EventList> events(String event, io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.EventList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.events(event, vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.NodeList> nodes(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.NodeList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.nodes(vertx.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.NodeList> nodes(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.mutiny.ext.consul.Watch<io.vertx.ext.consul.NodeList> ret = io.vertx.mutiny.ext.consul.Watch.newInstance((io.vertx.ext.consul.Watch)io.vertx.ext.consul.Watch.nodes(vertx.getDelegate(), options), TypeArg.unknown());
    return ret;
  }

  /**
   * @param handler the result handler
   * @return reference to this, for fluency
   */
  @Fluent
  private io.vertx.mutiny.ext.consul.Watch<T> __setHandler(Handler<io.vertx.mutiny.ext.consul.WatchResult<T>> handler) { 
    delegate.setHandler(new Handler<io.vertx.ext.consul.WatchResult<T>>() {
      public void handle(io.vertx.ext.consul.WatchResult<T> event) {
        handler.handle(io.vertx.mutiny.ext.consul.WatchResult.newInstance((io.vertx.ext.consul.WatchResult)event, __typeArg_0));
      }
    });
    return this;
  }

  /**
   * @param handler the result handler
   * @return 
   */
  public io.vertx.mutiny.ext.consul.Watch<T> setHandler(java.util.function.Consumer<io.vertx.mutiny.ext.consul.WatchResult<T>> handler) {
    return __setHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return reference to this, for fluency
   */
  @Fluent
  public io.vertx.mutiny.ext.consul.Watch<T> start() { 
    delegate.start();
    return this;
  }

  /**
   */
  public void stop() { 
    delegate.stop();
  }

  public static <T>Watch<T> newInstance(io.vertx.ext.consul.Watch arg) {
    return arg != null ? new Watch<T>(arg) : null;
  }


  public static <T>Watch<T> newInstance(io.vertx.ext.consul.Watch arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Watch<T>(arg, __typeArg_T) : null;
  }

}
